package net.sodacan.core;
/**
 * <p>The coordinator keeps track of the location of actorGroups among Hosts.
 * In a cluster configuration, the coordinator usually delegates to the Zookeeper
 * or similar coordinator. For a single-node (Host) configuration, the default coordinator
 * is sufficient.
 *</p>
 * <p>Part of the configuration for a host is managed by the coordinator. A single node (Host) setup can be configured
 * directly on startup. However, in a cluster configuration, configuration is supplied
 * by the network coordinator.</p>
 */

import java.util.List;

import net.sodacan.core.coordinator.HostEntry;

public interface Coordinator {
	public List<HostEntry> getActorGroupsForHost();
	public List<Integer> getHostsForActorGroup(int groupNumber);
	public int getLiveHostForActorGroup(int agNumber);
}
