package net.sodacan.core;
/**
 * <p>An ActorId has no meaning in the business model. Id is simply unique and carries 
 * with it some information used by Sodacan. This interface represents the factory that will be used to generate these ActorIds.</p>
 * <p>Three different parts to creating an actor id. The components are handled in this order:</p>
 * <ul>
 * <li>ActorType, a String, must reference a registered ActorType in the configuration and is provided to the ActorId factory.</li>
 * <li>Id is a string, usually from a UUID generated automatically by the implementation of the ActorIdFactory.</li>
 * <li>ActorGroup, an integer, must be in the range 1 through config.actorGroups. The assignment is permanent. It is generated by the factory.</li>
 * </ul>
 * <p>When an Actor creates an new Actor, the first step is to create the new Actor's
 * ActorId. The actual Actor object is created later when a message is sent to that new Actor
 * using its ActorId. Simply put, once an ActorId is created, the Actor it references can be assumed to exist.
 * Therefore, an newly created ActorId can be used immediately, by sending it messages.
 * </p>
 * <p>Sodacan does not keep an index of all known ActorIds. 
 * </p>
 * <p>If an ActorId is created and used briefly, then it is, essentially, gone from Sodacan without being explicitly deleted.
 * Now, if the Actor with that ActorId is used and that Actor has some saved state, the state will remain in the system. The state 
 * can be purged, later, depending on some ActorType-specific algorithm.
 * An ActorId is created but never used, it has no effect on the system.
 * </p>
 * <p>Sodacan makes no effort to serialize access to this factory. An implementation may need to synchronize or use Atomic actions.</p>
 */

public interface ActorIdFactory {
	public ActorId create(String actorType);
}
