package net.sodacan.core;

import java.io.Closeable;
import java.util.Collection;

/**
 * <P>An actor exists in a single permanent actorGroup. A actorGroup 
 * is responsible for scheduling work (processing inbound messages) for 
 * actors that are assigned to the actorGroup.</p>
 * <p>While any given actor is permanently tied to a single actorGroup,
 * the actorGroup itself is portable so that it can be "moved" from one Host to another
 * with minimal impact on the running application. </p>
 * <p>The location and state of a particular actorGroup is managed by the cluster 
 * coordinator. </p>
 * 
 * <P>A scheduler is attached to a actorGroup and this scheduler handles the 
 * message workload for the actorGroup.</p>
 */
public interface ActorGroup extends Closeable {
	/**
	 * A actorGroup has a unique id.
	 * @return The unique id of the actorGroup
	 */
	public int getActorGroupNumber();
	public void setHost(Host host);
	public Scheduler getScheduler();
	
	/**
	 * Add a message to be processed depending on Mode
	 * @param jug 
	 */
	public void addMessage(Jug jug);

}
