package net.sodacan.core;

import java.lang.reflect.Field;
import java.util.List;

import net.sodacan.core.jug.NormalMessage;

/**
 * <ul>
 * <li>An actor has a unique and permanent Id.</li>
 * <li>An actor is persistent. </li>
 * <li>An actor is permanently assigned to an actorGroup</li>
 * </ul>
 * <p>The flow is straightforward:
 * When the ActorGroup scheduler receives a message destined for a particular Actor
 * If that Actor is currently not in memory, it is constructed, any state is restored, and the 
 * scheduler starts the Actor running.</p>
 */
public interface Actor {
	public enum Builtin implements Verb {Start}; 
	
	/**
	 * <p>Process one message.</p> 
	 * <p>The actor can assume that no other inbound messages or method calls
	 * will occur during processing. The actor will be running in a dedicated thread.</p>
	 * <p>The result of this </p>
	 * @param message
	 * @return A Stage object containing messages to be processed during Commit
	 */
	public Stage processMessage(Message message);
	/**
	 * Send a message immediately rather than in the Stage.
	 * @param message
	 */
	public void send(Message message);

	public void close();

	public void restore();
	public void save();
	/**
	 * The default saves the state of the actor.
	 */
	public void exitingThread();


	public void callProcessMessage(NormalMessage nm);
	
	public ActorId getActorId();
	public Config getConfig();
	public ActorGroup getActorGroup();
	public void setActorGroup(ActorGroup actorGroup);
	/**
	 * The higher an eviction rate, the higher chance of eviction.
	 * This number can change dynamically with circumstances. This value does not assure 
	 * eviction (1.0) or retention (0.0).
	 * @return
	 */
	public float evictionProbability();

	public Stage getEmptyStage();
	
}
