/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.sodacan.core.Actor;
import net.sodacan.core.annotation.ActorType;

public class ClassUtilities {
    private static Class<? extends Actor> getClass(String className, String packageName) {
        try {
            Class<?> clazz = Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
            if (Actor.class.isAssignableFrom(clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Map<String, Class<? extends Actor>> getActorClassesFromPackage(String packageName) throws IOException {
        String line;
        HashMap<String, Class<? extends Actor>> classes = new HashMap<String, Class<? extends Actor>>();
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        if (stream == null) {
            throw new RuntimeException("Trouble loading packages from: " + packageName);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            Class<? extends Actor> clazz;
            if (!line.endsWith(".class") || (clazz = ClassUtilities.getClass(line, packageName)) == null) continue;
            ActorType actorType = clazz.getAnnotation(ActorType.class);
            if (actorType == null) {
                classes.put(clazz.getName(), clazz);
                continue;
            }
            classes.put(actorType.name(), clazz);
        }
        return classes;
    }
}

