/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.message;

import java.util.LinkedList;
import net.sodacan.core.ActorId;
import net.sodacan.core.message.AbstractMessage;

public abstract class EventMessage
extends AbstractMessage {
    private LinkedList<Route> routes = new LinkedList();

    public EventMessage(ActorId target) {
        super(target);
    }

    @Override
    public ActorId getTargetActorId() {
        Route route = this.peekRoute();
        if (route == null) {
            throw new RuntimeException("Event message has no route's left");
        }
        return route.getTarget();
    }

    public Route peekRoute() {
        Route route = this.routes.peek();
        return route;
    }

    public Route popRoute() {
        Route route = this.routes.pop();
        return route;
    }

    public void pushRoute(Route route) {
        this.routes.push(route);
    }

    public static class Route {
        private String verb;
        private ActorId target;

        public Route(String verb, ActorId target) {
            this.verb = verb;
            this.target = target;
        }

        public String getVerb() {
            return this.verb;
        }

        public ActorId getTarget() {
            return this.target;
        }
    }
}

