/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.journal;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;

public class JournalEntry {
    private long offset = -1L;
    private long timestamp;
    private int flags = 0;
    private int targetGroup = -1;
    private int payloadSize = 0;
    private byte[] payload = null;

    private JournalEntry(long offset) {
        this.offset = offset;
    }

    public JournalEntry() {
        this.offset = 0L;
    }

    public static JournalEntry fromByteBuffer(ByteBuffer bb) {
        bb.rewind();
        JournalEntry je = new JournalEntry();
        je.offset = bb.getLong();
        je.timestamp = bb.getLong();
        je.flags = bb.getInt();
        je.targetGroup = bb.getInt();
        je.payloadSize = bb.getInt();
        return je;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Offset=");
        sb.append(this.offset);
        sb.append(", Timestamp=");
        sb.append(Instant.ofEpochMilli(this.timestamp));
        sb.append(", Flags=");
        sb.append(this.flags);
        sb.append(", Group=");
        sb.append(this.targetGroup);
        if (this.payload == null) {
            sb.append(", Payload skipped");
        } else {
            sb.append(", Payload=");
            sb.append(new String(this.payload, StandardCharsets.UTF_8));
        }
        return sb.toString();
    }
}

