/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.host;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.Config;
import net.sodacan.core.Coordinator;
import net.sodacan.core.Host;
import net.sodacan.core.Message;
import net.sodacan.core.Stage;
import net.sodacan.core.coordinator.HostEntry;

public abstract class AbstractHost
implements Host {
    private Config config;
    private int hostNumber;
    private boolean initialized = false;
    private Coordinator coordinator;
    protected Map<HostEntry, ActorGroup> activeActorGroups = new HashMap<HostEntry, ActorGroup>();

    public AbstractHost(Config config) {
        this.config = config;
        this.hostNumber = config.getHostNumber();
        this.coordinator = this.getConfig().getCoordinator();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public int getHostNumber() {
        return this.hostNumber;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public void update() {
        List<HostEntry> actorGroups = this.coordinator.getActorGroupsForHost();
        for (Map.Entry<HostEntry, ActorGroup> entry : this.activeActorGroups.entrySet()) {
            if (actorGroups.contains(entry.getKey())) continue;
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to close ActorGroup " + String.valueOf(entry.getValue()), e);
            }
            this.activeActorGroups.remove(entry.getKey());
        }
        for (HostEntry hostEntry : actorGroups) {
            if (this.activeActorGroups.containsKey(hostEntry)) continue;
            ActorGroup ag = this.config.createActorGroup(hostEntry.getActorGroup());
            ag.setHost(this);
            this.activeActorGroups.put(hostEntry, ag);
        }
    }

    @Override
    public Set<HostEntry> getHostEntries() {
        return this.activeActorGroups.keySet();
    }

    @Override
    public ActorGroup getActorGroup(HostEntry hostEntry) {
        return this.activeActorGroups.get(hostEntry);
    }

    @Override
    public Set<ActorGroup> getActorGroups() {
        Set<HostEntry> hes = this.getHostEntries();
        HashSet<ActorGroup> ags = new HashSet<ActorGroup>();
        for (HostEntry he : hes) {
            ags.add(this.getActorGroup(he));
        }
        return ags;
    }

    @Override
    public void close() throws IOException {
        for (ActorGroup ag : this.getActorGroups()) {
            ag.close();
        }
        this.activeActorGroups.clear();
    }

    protected void replicate(int host, Message message) {
        System.out.println("Message " + String.valueOf(message) + " replcated to host " + host);
    }

    protected void forwardToHost(int hostNumber, Message message) {
    }

    @Override
    public boolean submit(Message message) {
        int agNumber = message.getTargetActorId().getActorGroup();
        ActorGroup ag = this.activeActorGroups.get(new HostEntry(this.getHostNumber(), agNumber, HostEntry.Mode.Live));
        if (ag != null) {
            ag.addMessage(message);
            for (Integer replicationHost : this.coordinator.getHostsForActorGroup(agNumber)) {
                if (replicationHost == agNumber) continue;
                this.replicate(replicationHost, message);
            }
        } else {
            this.forwardToHost(this.coordinator.getLiveHostForActorGroup(agNumber), message);
        }
        return true;
    }

    @Override
    public boolean submit(Stage stage) {
        for (Message message : stage.getMessages()) {
            this.submit(message);
        }
        return true;
    }
}

