/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.coordinator;

import java.util.ArrayList;
import java.util.List;
import net.sodacan.core.Config;
import net.sodacan.core.Coordinator;
import net.sodacan.core.coordinator.AbstractCoordinator;
import net.sodacan.core.coordinator.HostEntry;

public class SingleHostCoordinator
extends AbstractCoordinator
implements Coordinator {
    public SingleHostCoordinator(Config config) {
        super(config);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public List<HostEntry> getActorGroupsForHost() {
        ArrayList<HostEntry> entries = new ArrayList<HostEntry>(this.config.getActorGroups() + 1);
        int x = 1;
        while (x < this.config.getActorGroups() + 1) {
            entries.add(new HostEntry(this.config.getHostNumber(), x, HostEntry.Mode.Live));
            ++x;
        }
        return entries;
    }

    @Override
    public List<Integer> getHostsForActorGroup(int groupNumber) {
        ArrayList<Integer> entries = new ArrayList<Integer>(1);
        entries.add(this.config.getHostNumber());
        return entries;
    }

    @Override
    public int getLiveHostForActorGroup(int agNumber) {
        return this.config.getHostNumber();
    }
}

