/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.config;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorGroupAssigner;
import net.sodacan.core.ActorId;
import net.sodacan.core.ActorIdFactory;
import net.sodacan.core.Config;
import net.sodacan.core.Coordinator;
import net.sodacan.core.Host;
import net.sodacan.core.Scheduler;
import net.sodacan.core.actor.DefaultActorIdFactory;
import net.sodacan.core.actorgroup.DefaultActorGroup;
import net.sodacan.core.actorgroup.DefaultActorGroupAssigner;
import net.sodacan.core.coordinator.SingleHostCoordinator;
import net.sodacan.core.host.DefaultHost;
import net.sodacan.core.scheduler.DefaultScheduler;
import net.sodacan.core.util.ClassUtilities;

public class DefaultConfig
implements Config {
    private int hostNumber;
    private int actorGroups;
    private int actorGroupReplicas;
    private Function<Config, Integer> backpressureLimitFn;
    private Function<Config, Integer> backpressureWaitMsFn;
    private Function<Config, Integer> evictionFn;
    private Function<Config, Integer> actorGroupThreadsFn;
    private Function<Config, Integer> shutdownWaitMsFn;
    private ActorIdFactory actorIdFactory;
    private Host host;
    private ActorGroupAssigner actorGroupAssigner;
    private Coordinator coordinator;
    private Function<Config, Scheduler> schedulerFn;
    private BiFunction<Config, Integer, ActorGroup> actorGroupFn;
    private Map<String, Class<? extends Actor>> actorTypes;
    private Map<String, BiFunction<Config, ActorId, Actor>> actorFactories;

    private DefaultConfig(Builder builder) {
        this.hostNumber = builder.hostNumberFn.apply(this);
        if (this.hostNumber < 0) {
            throw new RuntimeException("The hostNumber must be positive");
        }
        this.actorGroupReplicas = builder.actorGroupReplicasFn.apply(this);
        if (this.actorGroupReplicas < 0) {
            throw new RuntimeException("The number of actorGroup replicas must be a positive number");
        }
        this.actorGroups = builder.actorGroupsFn.apply(this);
        if (this.actorGroups < 1) {
            throw new RuntimeException("The number of actorGroups must be 1 or greater");
        }
        this.coordinator = builder.coordinatorFn.apply(this);
        this.host = builder.hostFn.apply(this);
        this.actorGroupThreadsFn = builder.actorGroupThreadsFn;
        this.actorGroupAssigner = builder.actorGroupAssignerFn.apply(this);
        this.actorIdFactory = builder.actorIdFactoryFn.apply(this);
        this.schedulerFn = builder.schedulerFn;
        this.actorGroupFn = builder.actorGroupFn;
        this.actorTypes = builder.actorTypes;
        this.backpressureLimitFn = builder.backpressureLimitFn;
        this.evictionFn = builder.evictionFn;
        this.backpressureWaitMsFn = builder.backpressureWaitMsFn;
        this.shutdownWaitMsFn = builder.shutdownWaitMsFn;
        this.actorFactories = builder.actorFactories;
        this.addMissingActorFactories();
    }

    protected void addMissingActorFactories() {
        try {
            for (Map.Entry<String, Class<? extends Actor>> entry : this.actorTypes.entrySet()) {
                if (this.actorFactories.containsKey(entry.getKey())) continue;
                Class<? extends Actor> clazz = entry.getValue();
                Constructor<? extends Actor> ctor = clazz.getConstructor(Config.class, ActorId.class);
                if (ctor == null) {
                    throw new RuntimeException("Actor " + entry.getKey() + " Does not support a standard constructor, use a custom factory");
                }
                BiFunction<Config, ActorId, Actor> f = (config, actorId) -> {
                    try {
                        return (Actor)ctor.newInstance(config, actorId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error constructing actor " + (String)entry.getKey(), e);
                    }
                };
                this.actorFactories.put(entry.getKey(), f);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating default actor factories", e);
        }
    }

    @Override
    public int getHostNumber() {
        return this.hostNumber;
    }

    @Override
    public int getActorGroups() {
        return this.actorGroups;
    }

    @Override
    public int getActorGroupReplicas() {
        return this.actorGroupReplicas;
    }

    @Override
    public int getBackpressureLimit() {
        int limit = this.backpressureLimitFn.apply(this);
        if (limit < 1) {
            throw new RuntimeException("Backpressure limit must be a positive number");
        }
        return limit;
    }

    @Override
    public int getEviction() {
        return this.evictionFn.apply(this);
    }

    @Override
    public ActorGroupAssigner getActorGroupAssigner() {
        return this.actorGroupAssigner;
    }

    @Override
    public ActorIdFactory getActorIdFactory() {
        return this.actorIdFactory;
    }

    @Override
    public int getActorGroupThreads() {
        return this.actorGroupThreadsFn.apply(this);
    }

    @Override
    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public ActorGroup createActorGroup(int actorGroupNumber) {
        return this.actorGroupFn.apply(this, actorGroupNumber);
    }

    @Override
    public Scheduler createScheduler() {
        return this.schedulerFn.apply(this);
    }

    @Override
    public int getBackpressureWaitMs() {
        return this.backpressureWaitMsFn.apply(this);
    }

    @Override
    public int getShutdownWaitMs() {
        return this.shutdownWaitMsFn.apply(this);
    }

    @Override
    public String getProperty(String name) {
        return System.getProperty(name);
    }

    @Override
    public Class<? extends Actor> getActorClass(String actorType) {
        return this.actorTypes.get(actorType);
    }

    @Override
    public Actor createActor(ActorId actorId) {
        String actorType = actorId.getType();
        if (actorType == null) {
            throw new RuntimeException("Null ActorType not allowed");
        }
        BiFunction<Config, ActorId, Actor> factory = this.actorFactories.get(actorType);
        if (factory == null) {
            throw new RuntimeException("No factory for actorType " + actorType);
        }
        return factory.apply(this, actorId);
    }

    @Override
    public void printConfig(PrintStream out) {
        out.println("Local Static");
        out.println(" actorIdFactory=" + String.valueOf(this.getActorIdFactory()));
        out.println(" Host: " + String.valueOf(this.getHost()));
        out.println(" hostNumber=" + this.getHostNumber());
        out.println("Global Static");
        out.println("  actorGroups=" + this.getActorGroups());
        out.println("  actorGroupReplicas=" + this.getActorGroupReplicas());
        out.println("Local Static factory");
        out.println(" Coordinator: " + String.valueOf(this.getCoordinator()));
        out.println(" actorGroupAssigner=" + String.valueOf(this.getActorGroupAssigner()));
        out.println(" ActorIdFactory=" + String.valueOf(this.getActorIdFactory()));
        out.println("Global Dynamic");
        out.println(" backpressureLimit=" + this.getBackpressureLimit());
        out.println(" backpressureWaitMs=" + this.getBackpressureWaitMs());
        out.println(" eviction=" + this.getEviction());
        out.println(" actorGroupThreads=" + this.getActorGroupThreads());
        out.println(" shutdownWaitMs=" + this.getShutdownWaitMs());
        out.println("Property: os.name=" + this.getProperty("os.name"));
        out.println("actors: ");
        this.listActors(out);
    }

    @Override
    public void listActors(PrintStream out) {
        for (Map.Entry<String, Class<? extends Actor>> entry : this.actorTypes.entrySet()) {
            out.print("  ");
            out.print(entry.getKey());
            out.print("=");
            out.println(entry.getValue().getName());
        }
    }

    public static class Builder {
        private Function<Config, Integer> hostNumberFn = config -> 1;
        private Function<Config, Integer> actorGroupsFn = config -> 5;
        private Function<Config, Integer> actorGroupReplicasFn = config -> 0;
        private Function<Config, Integer> backpressureLimitFn = config -> 100000;
        private Function<Config, Integer> backpressureWaitMsFn = config -> 200;
        private Function<Config, Integer> shutdownWaitMsFn = config -> 200;
        private Function<Config, Integer> evictionFn = config -> 8;
        private Function<Config, Integer> actorGroupThreadsFn = config -> 20;
        private Function<Config, ActorGroupAssigner> actorGroupAssignerFn = config -> new DefaultActorGroupAssigner((Config)config);
        private Function<Config, Scheduler> schedulerFn = config -> new DefaultScheduler((Config)config);
        private BiFunction<Config, Integer, ActorGroup> actorGroupFn = (config, id) -> new DefaultActorGroup((Config)config, (int)id);
        private Function<Config, Coordinator> coordinatorFn = config -> new SingleHostCoordinator((Config)config);
        private Function<Config, Host> hostFn = config -> new DefaultHost((Config)config);
        private Function<Config, ActorIdFactory> actorIdFactoryFn = config -> new DefaultActorIdFactory();
        private Map<String, Class<? extends Actor>> actorTypes = new HashMap<String, Class<? extends Actor>>();
        private Map<String, BiFunction<Config, ActorId, Actor>> actorFactories = new HashMap<String, BiFunction<Config, ActorId, Actor>>();

        public Builder hostNumber(int hostNumber) {
            this.hostNumberFn = config -> hostNumber;
            return this;
        }

        public Builder hostNumber(Function<Config, Integer> hostNumberFn) {
            this.hostNumberFn = hostNumberFn;
            return this;
        }

        public Builder actorGroups(int actorGroups) {
            this.actorGroupsFn = config -> actorGroups;
            return this;
        }

        public Builder actorGroups(Function<Config, Integer> actorGroupsFn) {
            this.actorGroupsFn = actorGroupsFn;
            return this;
        }

        public Builder actorGroupReplicas(int actorGroupReplicas) {
            this.actorGroupReplicasFn = config -> actorGroupReplicas;
            return this;
        }

        public Builder actorGroupReplicas(Function<Config, Integer> actorGroupReplicasFn) {
            this.actorGroupReplicasFn = actorGroupReplicasFn;
            return this;
        }

        public Builder eviction(int eviction) {
            this.evictionFn = config -> eviction;
            return this;
        }

        public Builder eviction(Function<Config, Integer> evictionFn) {
            this.evictionFn = evictionFn;
            return this;
        }

        public Builder actorGroupThreads(int actorGroupThreads) {
            this.actorGroupThreadsFn = config -> actorGroupThreads;
            return this;
        }

        public Builder actorGroupThreads(Function<Config, Integer> actorGroupThreadsFn) {
            this.actorGroupThreadsFn = actorGroupThreadsFn;
            return this;
        }

        public Builder backpressureLimit(Function<Config, Integer> backpressureLimitFn) {
            this.backpressureLimitFn = backpressureLimitFn;
            return this;
        }

        public Builder backpressureLimit(int backpressureLimit) {
            this.backpressureLimitFn = config -> backpressureLimit;
            return this;
        }

        public Builder backpressureWaitMs(Function<Config, Integer> backpressureWaitMsFn) {
            this.backpressureWaitMsFn = backpressureWaitMsFn;
            return this;
        }

        public Builder backpressureWaitMs(int backpressureWaitMs) {
            this.backpressureWaitMsFn = config -> backpressureWaitMs;
            return this;
        }

        public Builder actorGroupAssigner(Function<Config, ActorGroupAssigner> actorGroupAssignerFn) {
            this.actorGroupAssignerFn = actorGroupAssignerFn;
            return this;
        }

        public Builder actorIdFactory(Function<Config, ActorIdFactory> actorIdFactoryFn) {
            this.actorIdFactoryFn = actorIdFactoryFn;
            return this;
        }

        public Builder registerActorsInPackage(String packageName) {
            try {
                this.actorTypes.putAll(ClassUtilities.getActorClassesFromPackage(packageName));
            }
            catch (IOException e) {
                throw new RuntimeException("Trouble loading Actors from package " + packageName, e);
            }
            return this;
        }

        public Builder registerActorType(String actorType, Class<? extends Actor> type) {
            this.actorTypes.put(actorType, type);
            return this;
        }

        public Builder actorFactory(String actorType, BiFunction<Config, ActorId, Actor> actorFactory) {
            this.actorFactories.put(actorType, actorFactory);
            return this;
        }

        public Builder shutdownWaitMs(Function<Config, Integer> ms) {
            this.shutdownWaitMsFn = ms;
            return this;
        }

        public Builder shutdownWaitMs(int ms) {
            this.shutdownWaitMsFn = config -> ms;
            return this;
        }

        public Builder coordinator(Function<Config, Coordinator> coordinatorFn) {
            this.coordinatorFn = coordinatorFn;
            return this;
        }

        public Builder host(Function<Config, Host> hostFn) {
            this.hostFn = hostFn;
            return this;
        }

        public Builder schedulerCreator(Function<Config, Scheduler> schedulerFn) {
            this.schedulerFn = schedulerFn;
            return this;
        }

        public Builder actorGroupCreator(BiFunction<Config, Integer, ActorGroup> actorGroupFn) {
            this.actorGroupFn = actorGroupFn;
            return this;
        }

        public Builder property(String name, String value) {
            System.setProperty(name, value);
            return this;
        }

        public Config build() {
            return new DefaultConfig(this);
        }
    }
}

