/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actorgroup;

import java.io.IOException;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.Config;
import net.sodacan.core.Host;
import net.sodacan.core.Message;
import net.sodacan.core.Scheduler;
import net.sodacan.core.Stage;

public abstract class AbstractActorGroup
implements ActorGroup {
    private Config config;
    private int actorGroupNumber;
    private Scheduler scheduler;
    protected Host host = null;

    public AbstractActorGroup(Config config, int actorGroupNumber) {
        this.config = config;
        this.actorGroupNumber = actorGroupNumber;
        if (actorGroupNumber > config.getActorGroups() || actorGroupNumber < 0) {
            throw new RuntimeException("actorGroup number must be less than the number of actorGroups and not negative");
        }
        this.scheduler = config.createScheduler();
        this.scheduler.setActorGroup(this);
        System.out.println("Actor group created: " + String.valueOf(this));
    }

    @Override
    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void close() throws IOException {
        this.scheduler.close();
        System.out.println("Actor group closed: " + String.valueOf(this));
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public int getActorGroupNumber() {
        return this.actorGroupNumber;
    }

    public int getMessageLoad() {
        return this.scheduler.getMessageLoad();
    }

    public void increaseMessageLoad() {
        this.scheduler.increaseMessageLoad();
    }

    public void reduceMessageLoad() {
        this.scheduler.reduceMessageLoad();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "=" + this.getActorGroupNumber();
    }

    @Override
    public void addMessage(Message message) {
        this.getScheduler().addMessage(message);
    }

    @Override
    public void submit(Message message) {
        this.host.submit(message);
    }

    @Override
    public void submit(Stage stage) {
        this.host.submit(stage);
    }
}

