/*
 * Decompiled with CFR 0.152.
 */
package net.sodacan.core.actor;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.sodacan.core.Actor;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.Precheck;
import net.sodacan.core.Scheduler;
import net.sodacan.core.Stage;
import net.sodacan.core.message.Evict;

public class ActorEntry
implements Runnable {
    protected ActorId actorId;
    protected Actor actor = null;
    private BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>();
    private List<Message> holding = new LinkedList<Message>();
    protected Scheduler scheduler;
    protected Config config;
    protected long usage = 0L;

    public ActorId getActorId() {
        return this.actorId;
    }

    public long getUsage() {
        return this.usage;
    }

    public ActorEntry(Config config, Scheduler scheduler, ActorId actorId) {
        this.config = config;
        this.scheduler = scheduler;
        this.actorId = actorId;
    }

    public void queueMessage(Message message) {
        this.queue.add(message);
        this.scheduler.increaseMessageLoad();
        if (message instanceof Evict) {
            this.scheduler.increaseEvictionCount();
        } else {
            this.scheduler.increaseMessageCount();
        }
    }

    protected void handleStage(Stage stage) {
        ActorGroup actorGroup = this.scheduler.getActorGroup();
        if (actorGroup != null) {
            actorGroup.submit(stage);
        } else {
            for (Message msg : stage.getMessages()) {
                this.scheduler.addMessage(msg, true);
            }
        }
    }

    protected void callProcessMessage(Message message) {
        ++this.usage;
        Stage stage = this.actor.processMessage(message);
        this.scheduler.reduceMessageLoad();
        this.handleStage(stage);
    }

    protected void callRequest(Precheck pca, Message message) {
        Stage stage = pca.request(message);
        this.handleStage(stage);
    }

    protected boolean isEviction(Message message) {
        if (message instanceof Evict) {
            this.scheduler.reduceMessageLoad();
            int queueSize = this.queue.size();
            if (queueSize > 0) {
                System.out.println("Eviction with " + queueSize + " in queue");
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            if (this.actor == null) {
                this.actor = this.config.createActor(this.actorId);
            }
            if ((var2_1 = this.actor) instanceof Precheck) {
                pca = (Precheck)var2_1;
                block2: while (true) {
                    if (this.isEviction(message = this.queue.take())) {
                        return;
                    }
                    if (pca.hold(message) && !pca.release(message)) {
                        this.callRequest(pca, message);
                        this.holding.add(message);
                        continue;
                    }
                    this.callProcessMessage(message);
                    var5_7 = this.holding.iterator();
                    while (true) {
                        if (var5_7.hasNext()) ** break;
                        continue block2;
                        m = var5_7.next();
                        if (!pca.release(message)) continue;
                        this.holding.remove(m);
                        this.callProcessMessage(message);
                    }
                    break;
                }
            }
            while (true) {
                if (this.isEviction(message = this.queue.take())) {
                    return;
                }
                this.callProcessMessage(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in actor " + String.valueOf(this.actorId), e);
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }
}

