package net.sodacan.sample.message;

import java.util.HashMap;
import java.util.Map;

import net.sodacan.core.ActorId;
import net.sodacan.core.Message;
import net.sodacan.core.message.EventMessage;
import net.sodacan.sample.record.Info;

/**
 *  <p>For our simplest application, we logically need two message but Sodacan
 *  allows a single message definition to do double duty: First, as a way to request
 *  that an actor do something (generate a string) and then for the first  actor to 
 *  send a message of the same type to a second actor. Further, the routing from
 *  the first actor to the second actor is included in this single message format.</p>
 * <p>The builtin EventMessage format allows for this routing automatically.</p>
 * <p>The primary payload of a message is a separate class called a payload.
 * This payload can be used in different messages and within an actor to represent
 * both local state and foreign data. So, the payload, named Info in this case, 
 * is defined separately. However, as a convention, it is wise to define a record as
 * an inner class of the actor class that maintains the source-of-truth for that record.
 * Such as CustomerInfo record as an public inner class of the Customer actor.
 * </p>
 */
public class InfoMessage extends EventMessage implements Message {
	
	private Map<String, Object> records = new HashMap<>();
	
	public InfoMessage(ActorId target) {
		super(target);
	}
	public void addRecord(String name, Object record) {
		records.put(name, record);
	}
	
	public Object getRecord(String name) {
		return records.get(name);
	}
	
}
