package net.sodacan.sample.actor;

import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.Stage;
import net.sodacan.core.actor.AbstractActor;
import net.sodacan.core.annotation.ActorType;
import net.sodacan.core.annotation.Handler;
import net.sodacan.sample.message.InfoMessage;
import net.sodacan.sample.record.Info;

/**
 * <p>Our simple job is to, upon request, provide the string "Hello World" into a message
 * and forward that message to the next target actor specified in the message.
 * </p>
 * <p>This actor class will have only one instance. So, in this case, the actorId used to 
 * target this actor will just be its type name; No identifier. In this way, we can treat this 
 * actor as a singleton, and as with all actors,
 * messages will be delivered to this single instance of an actor serially.</p>
 * <p>Note: Our actor has a public constructor. But that just allows Sodacan to construct the actor
 * as needed. You should never have to construct an Actor yourself. The constructor is free to
 * initialize any local structures but the actor's formal state, if any, will be delivered to the
 * actor as a message.</p>
 */
@ActorType(name="hwg")
public class HelloWorldGenerator extends AbstractActor implements Actor {

	public HelloWorldGenerator(Config config, ActorId actorId) {
		super(config,actorId);
	}
	
	/**
	 * <p>You'll notice that the message parameter is not final. That is on purpose.
	 * First of all, messages are in serialized form during
	 * delivery so that there is no risk of unintentional modification of the
	 * sender's message. Secondly, it is common for actors to enhance event messages and let 
	 * them continue on their way to the next actor in their route. Since the routing 
	 * information is contained in the message (header), recreating this information 
	 * would be tedious if not error prone if an actor created a new message when not necessary.
	 * </p>
	 * <p>The stage method adds the message to the outbound message stage
	 * so that, when the actor is finished processing the message, any outgoing messages 
	 * that have been "staged" during processing will be sent on their way. </p>
	 * <p>Calling rollback empties the stage thus preventing any outgoing 
	 * effects of the actor. In addition, the actor's internal state
	 * is restored to the way it was *before* the message arrived. The rollback occurs at 
	 * the time the call is made. This allows error processing which may involve sending
	 * an error message and may include changes to the actor's state.
	 * </p>
	 * @param message
	 * @return
	 */
	@Handler(verb="request",state="active")
	public boolean processInfoRequest(InfoMessage message) {
		message.addRecord("result", new Info("Hello World"));
//		stage(message);
		return true;
	}

	@Override
	public Stage processMessage(Message message) {
//	stage(new Info("Hello World"));
		return null;
	}
}
