package net.sodacan.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import net.sodacan.core.Actor;
import net.sodacan.core.annotation.ActorType;

public class ClassUtilities {

	@SuppressWarnings("unchecked")
	private static Class<? extends Actor> getClass(String className, String packageName) {
        try {
            Class<? extends Actor> clazz = (Class<? extends Actor>) Class.forName(packageName + "." + className.substring(0, className.lastIndexOf('.')));
    		if (Actor.class.isAssignableFrom(clazz) 
    				&& !clazz.isInterface() 
    				&& !Modifier.isAbstract(clazz.getModifiers()) ) {
    			return (Class<? extends Actor>)clazz;
    		}
        } catch (ClassNotFoundException e) {
            // TODO: handle the exception
        }
        return null;
    }

	public static Map<String,Class<? extends Actor>> getActorClassesFromPackage(String packageName ) throws IOException {
		Map<String,Class<? extends Actor>> classes = new HashMap<>();
		InputStream stream = ClassLoader.getSystemClassLoader()
          .getResourceAsStream(packageName.replaceAll("[.]", "/"));
		if (stream==null) {
			throw new RuntimeException("Trouble loading packages from: " + packageName);
		}
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while (true) {
        	String line = reader.readLine();
        	if (line==null) break;
        	if (line.endsWith(".class")) {
        		Class<? extends Actor> clazz =  getClass(line, packageName);
        		if (clazz!=null) {
        			ActorType actorType = clazz.getAnnotation(ActorType.class);
        			if (actorType==null) {
        				classes.put(clazz.getName(), clazz);
        			} else {
        				classes.put(actorType.name(), clazz);
        			}
        		}
        	}
        }
        return classes;
	}
}
