package net.sodacan.core.util;

public class Base62 {
	static final String BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"; 
	static final long LEN = BASE62.length();
	/**
	 * A String buffer containing the provided long value encoded as a base62 string
	 * @param sb
	 * @param value
	 */
	public static void encode(StringBuffer sb, final long value ) {
		int x = (int) (value % LEN);
		if (value!=0) {
			encode(sb,value/LEN);
			sb.append(BASE62.charAt(x));
		}
	}

	/**
	 * Convert a number to base62 and append it to the supplied string.
	 * @param baseId A String containing "our" id
	 * @param nextId A long containing the next id to append
	 * @return An Id string with the neextId appended
	 */
	public static String encodeNextId(final String baseId, final long nextId) {
		StringBuffer sb = new StringBuffer();
		sb.append(baseId);
		if (sb.length()!=0) sb.append('.');
		if (nextId==0) sb.append("0");
		else encode(sb,nextId);
		return sb.toString();
	}

}
