/**
 * <p>Sodacan is a pure actor model framework. Actors in Sodacan include "big" actors such as a department list. And, 
 * small actors, such as an individual department. An actor can receive messages, create other actors and send messages. All actors 
 * are single threaded. An Actor has a permanent ActorId, unique in the system. An Actor can have "state". An Actor is permanently 
 * assigned to an ActorGroup. The assignment is usually
 * random, but permanent. ActorGroups are usually replicated across a network of Hosts, one Host per node. A Host 
 * temporarily hosts one or more 
 * ActorGroups and ActorGroups can be moved from one Host to another. ActorGroups can (and should) be replicated for durability.
 * The configuration can specify the number of ActorGroup replicas to maintain.</p>
 * <p>An actor has state. This fact is exploited in Sodacan as a way to avoid using a separate database. 
 * In other words, the logic that protects and uses data is kept together with the data in an Actor. 
 * </p>
 * 
 * <p>Sodacan is a peer-to-peer network. No single point of failure. It is common to operate at least two hot replicas for
 * any given ActorGroup. Additional "cold" replicas can also be configured. 
 * Cold replicas require less compute but take longer to come on-line. 
 * Having only a single copy of any particular ActorGroup is not durable or fault-tolerant. 
 * A minimum of three Hosts are required for durability. But the number 
 * can be much higher for horizontal scaling.
 * </p>
 * <p>A high degree of parallelism is provided by Sodacan, one might even say it supports the ultimate degree of parallelism. 
 * To the application developer, each Actor operates independent of all other Actors.
 * As long as an actor follows some simple rules, the application developer should never have to worry about concurrency.
 * From a design perspective, actors provide a way to represent a business process without having to worry about 
 * data persistence (ie a separate database): If an Actor "owns" some data, that data stays with the Actor. Sodacan also supports "foreign data"
 * which is acquired transparently from the owning Actor. The mechanism still uses messaging, it just hides the details for most situations.
 * </p>
 * <p>The oversimplified flow in any given Actor is to process inbound messages delivered by the framework and "stage" zero or more outbound messages
 * that will be sent upon commit within the Actor.
 * </p>
 * <p>Each Message is delivered one at a time to each Actor. Some Actors might have no persistent data so that their state does not have to be saved.
 * For those Actors that do have state, the state will be saved in a Journal. The Message carrying the state of an Actor is also sent to 
 * other replicas of the ActorGroup on different Hosts.  
 * </p>
 * <p>In addition to simple actor-to-actor messages, some messages can be used to provide complex workflow. 
 * The message can even be "enhanced" as it travels.
 * </p>
 * <p>This package contains all of the important interfaces used in Sodacan.
 * Each of the packages below this package contain a more detailed description of the capabilities provided by that package, including the implementation classes.</p>
 * @author John Churin
 */
package net.sodacan.core;
