/**
 * <p>Message flow is described here. Specific message types are described in the respective classes. A message usually originates
 * in an Actor. The following describes the message flow from source Actor to destination Actor.</p>
 * <p>Messages are generally composed of a header and a payload. During message delivery, the payload is not considered. The 
 * header of a message can vary in structure but the critical element is the current target (destination) ActorId.  
 * ActorId contains the ActorGroup number. This number is important in determining how the message will be delivered.</p>
 * <p>Each Actor has an inbound message queue, sometimes called a mailbox. Sodacan tries to minimize the number of steps, especially
 * intermediate queues between the source and destination Actors.</p>
 * <p>While an Actor is processing a message, outgoing message are accumulated in a *stage*. Once the Actor "commits", the messages in the 
 * stage can be sent. As much work as possible is done in the Actor's thread.</p>
 * <p>If the destination of a message is within the same ActorGroup, the message can be delivered directly to the destination Actor's
 * input queue.</p>
 * <p>Message delivery between ActorGroups is more formal; Even if the two ActorGroups are on the same Host. This is necessary because
 * ActorGroups can move from one Host to another.</p>
 * <p>While an Actor *could* send messages directly to other ActorGroups, even on other Hosts, this has the potential of affecting 
 * the liveliness of the system. So, instead, when an Actor needs to send a message to another ActorGroup, it just directs the message to 
 * a special Actor, ActorGroupSender, that operates within the same ActorGroup, where it is sent to its destination. 
 * The ActorGroup has an ActorGroupSender
 * for each destination ActorGroup.  
 * This approach allows the source Actor to continue processing more messages. It hands over message delivery to another Actor that specializes 
 * in message delivery. It also allows the ActorGroupSender Actor to consolidate messages from source Actors into larger message 
 * containers for more efficient delivery.</p>
 * <p>The ActorGroupSender Actors are sent periodic messages from their Host telling the senders which Host to send a message 
 * to for that particular target ActorGroup.
 * </p>
 * <p>The rest of the message flow exploits the fact that Sodacan Hosts support an HTTP server. This server can handle messages from 
 * outside and inside the Sodacan environment. So, when an ActorGroupSender is ready to send a message, it uses an HTTP client 
 * to send the message to the correct Host. From there the message is directly routed through to the
 * destination Actor's message queue. (The message is briefly handled by the ActorGroup, but is not queued by the ActorGroup.)</p>
 * <p>The whole message path between ActorGroups is dependent on the coordinator Host/ActorGroup configuration. The ActorGroupSenders receive updates
 * to this configuration when it changes.</p>
 * <p>StateMessages follow a different path: Among the outgoing messages from an Actor is one or more StateMessages for Actors that have a state
 * and that state changed during processing. This type of message is sent to a special Actor called the StateRouter. The StateRouter determines destinations for
 * a StateMessage. First, it send the state message to the JournalWriter actor for the ActorGroup of the Actor on the local Host and also copies
 * it to any other replica ActorGroup JournalWriters. 
 * This flow is described in more detail in the journal package. Non-state messages can also be routed to the JournalWriter when appropriate.</p>
 * @see net.sodacan.core.host
 * @see net.sodacan.core.actorgroup
 * @see net.sodacan.core.journal
 */
package net.sodacan.core.message;