package net.sodacan.core.message;

import java.time.Instant;

import net.sodacan.core.ActorId;


/**
 * Update messages are generally processed by an actor in order to
 * update foreign records in an actor that is not the source of truth for the 
 * specified record. This type of message should not be used
 * to represent an event such as to add or change the source of truth.
 * Use a sub-class of event message for that purpose.
 */
public class UpdateMessage extends AbstractMessage {
	private Instant currentAsOf;

	public UpdateMessage(ActorId target, Instant currentAsOf) {
		super(target);
		this.currentAsOf = currentAsOf;
	}

	public Instant getCurrentAsOf() {
		return currentAsOf;
	}
}

