package net.sodacan.core.message;

import net.sodacan.core.ActorId;

/**
 * <p>A State Message carries the state, or part of the state, of an Actor. 
 * These messages are part of the persistence capability of Sodacan. </p>
 * <p>When an Actor finishes processing an EventMessage, the current state of
 * the Actor is packed up into a StateMessage and usually sent to a RoutingActor.
 * The state is also sent to local storage, but an actor doesn't need a message
 * to access it's local storage.
 * </p>
 * <p>The job of the RoutingActor is to send the StateMessage to the following Actors:
 * </p>
 * <ul>
 * <li>The JournalWriter in the local ActorGroup</li>
 * <li>The JournalWriter in zero or more replicas of the same ActorGroup running on different Hosts.</li>
 * <li>The target Actor running in Hot standby mode on other Hosts</li>
 * </ul>

 */
public class StateMessage extends HostMessage {
	private ActorId subject;
	public StateMessage(int host, ActorId target, ActorId subject) {
		super(host,target);
		this.subject = subject;
	}
	
}
