package net.sodacan.core.message;

import net.sodacan.core.ActorId;

/**
 * <p>A query message carries very little if any payload. It
 * is used to induce the owner of certain data to reply to the
 * Actor specified. Most QueryMessages are generated during a Precheck.</p>
 * <p>A subclass of this class will indicate the nature of the record
 * needed.</p>
 */
public abstract class QueryMessage extends AbstractMessage {
	ActorId replyTo;
	
	public QueryMessage( ActorId target, ActorId replyTo) {
		super(target);
		this.replyTo = replyTo;
	}

	public ActorId getReplyTo() {
		return replyTo;
	}

}
	
