package net.sodacan.core.message;

import net.sodacan.core.Actor;
import net.sodacan.core.ActorId;

/**
 * When a parent actor spawns a child actor, a special condition occurs:
 * The parent assigns an actor id for the child but
 * the child actor does not exist yet nor is the parent 
 * allowed to interact with this new child actor. This special message
 * is used by the infrastructure to create the new actor. This message
 * is also sent to the actor so that it can do any necessary initialization.
 * This message should be the first one sent to the new actor. This is usually
 * not an issue because the actor is new and the only actor that knows it 
 * exists is the parent actor. Of course it wouldn't be unusual for the
 * parent to immediately *follow* the NewActor message with a normal event message.
 * This message can be subclassed to carry additional startup information for
 * the new child. The infrastructure will ignore this added data.
 */
public class NewActorMessage extends LifecycleMessage {
	
	public NewActorMessage(ActorId target) {
		super(target);
	}
	private ActorId newActorId;
	private Class<? extends Actor> actorClass;
	public ActorId getNewActorId() {
		return newActorId;
	}
	public void setNewActorId(ActorId newActorId) {
		this.newActorId = newActorId;
	}
	public Class<? extends Actor> getActorClass() {
		return actorClass;
	}
	public void setActorClass(Class<? extends Actor> actorClass) {
		this.actorClass = actorClass;
	}
}

