package net.sodacan.core.message;

import net.sodacan.core.ActorId;

/**
 * <p>Most messages directed toward a specific Actor are sent to the 
 * Host running the <i>live</i> version of the ActorGroup containing the target actor. 
 * But there are times when a message needs to be addressed to a specific Host, even if its
 * not holding the "live" version of the Actor. 
 * </p>
 * <p>This kind of message must be able to specify the specific Host that is to receive
 * and process the message. StateMessages used for replication are a good example.
 * </p>
 *
 */
public abstract class HostMessage extends AbstractMessage {
	private int host;
	
	public HostMessage(int host, ActorId target) {
		super(target);
		this.host = host;
	}
	
	public int getHost() {
		return host;
	}
	
}
