package net.sodacan.core.message;

import java.time.Instant;

import net.sodacan.core.ActorId;
import net.sodacan.core.Message;
import net.sodacan.core.SodacanException;

public abstract class AbstractMessage implements Message {
	private ActorId orginatingActorId;
	private Instant originatingTime;
	private ActorId targetActorId;
	
	public AbstractMessage(ActorId target) {
		this.targetActorId = target;
	}
	
	/**
	 * Most messages just have a single target actorId. Some are fancier and need
	 * alternative ways to determine the target id.
	 */
	@Override
	public ActorId getTargetActorId() {
		return targetActorId;
	}

	
	public ActorId getOrginatingActor() {
		return orginatingActorId;
	}

	public void setOrginatingActor(ActorId orginatingActorId) {
		this.orginatingActorId = orginatingActorId;
	}

	public Instant getOriginatingTime() {
		return originatingTime;
	}

	public void setOriginatingTime(Instant originatingTime) {
		this.originatingTime = originatingTime;
	}

	@Override
	public String toString() {
		return "AbstractMessage [targetActorId=" + targetActorId + "]";
	}
	
}
	
