/**
 * <p>A Sodacan journal primarily stores Actor state messages which can also be interleaved with other messages. Most of this description covers State Messages.
 * <p>There is one logical journal for each ActorGroup per Host. A journal contains journal entries. Each entry has a variable length. 
 * Journal entries are identified by a 
 * monotonic long field. The identifiers are not contiguous. The journal is immutable except for new entries appended.</p>
 * <p>A journal is composed of one or more journal files. Journal files are "rotated" under several conditions. Taken together, the 
 * journal files represent the complete journal for an actor group. </p>
 * <p>A journal can be read sequentially as follows: Each journal file has a header containing the base journal entry id of that file. The 
 * first journal file's header will have a base entry id corresponding to the position in that file. Subsequent journal files will have a
 * base id relative to that file. Using the desired id minus the base id yields the file position in that file.</p>
 * 
 * <p>In practice, journal files are rotated so that 
 * no one file grows too large. A journal file might also be rotated if the file format changes. 
 * </p>
 * <p>Each journal file begins with a header record which carries several important fields including the starting 
 * id of the file. The file position can be deduced from the id.</p>
 * <p>Each entry in a journal has two relevant fields: At the beginning of  the entry is a long that corresponds to the file 
 * position of the entry. This is primarily used as
 * a check on the validity of the entry. Following the payload for an entry, another long is added that carries the logical entry id 
 * for the *next* entry in that journal. When the journal file is opened for append, its a simple matter of backing up four bytes from the end
 * of the file to get the next entry id. This field is also used to begin a new follow-on file where the next id at the end of the previous file
 * becomes the starting id of the next journal file. 
 * </p>
 * <p>Each journal has a companion index file. The index file is never rotated. However, it can be recreated by reading the journal file(s).
 * The index is used to locate the most recent journal entry for each actor managed by the ActorGroup.
 * </p>
 * <p>The journal files are organized as follows: </p>
 * <ul>
 * <li>All files for a single host are stored in a directory tree structure. </li>
 * <li>Each host is typically on a separate node and 
 * has a unique id which is used to name the host folder under the root folder (from Sodacan Config).</li>
 * <li>A host never shares a journal with other hosts and an ActorGroup journal is 
 * never shared with other ActorGroups on the same host or other hosts.</li>
 * <li>ActorGroups also have a unique id which is used to name a folder within the host folder that holds the journal and related files
 * for that ActorGroup.</li>
 * <li>Within an ActorGroup, one subfolder, named <code>journal/</code>, holds all of the journal files for that ActorGroup. The files 
 * in this folder hold the source of truth for that Host/ActorGroup. If files are lost from this folder, they must be recovered from another 
 * replica on another host. </li>
 * <li>Journals for an inactive (cold) Host/ActorGroup will fall behind as long as the ActorGroup is cold.</li> 
 * <li>When an ActorGroup on a Host is inactive, no messages are being queued or processed by the Actors in that cold ActorGroup.</li>
 * <li>When the Coordinator puts an ActorGroup in warm status, its Journal will need to be brought up to date. Another warm (preferably) 
 * replica will need to send Journal updates to the cold Journal, and keep the state messages from the warm ActorGroup coming to 
 * the cold ActorGroup allow that cold ActorGroup to become and stay synchronized.</li>
 * <li>Once this level of synchronization is achieved, the warm ActorGroup can begin the process of bringing the Actor's local state up to date.
 * A warm ActorGroup does not care about the state of individual Actor's state.</li>
 * <li>Handling a transition from warm to hot status all happens within the ActorGroup. The ActorGroup needs to read its journal and send state update
 * Messages to the Actors in that non-live ActorGroup.
 * This activity has the appearance of imposing on the sanctity of an Actor, but since the 
 * ActorGroup is not live, the framework is free to setup the underlying storage used by an Actor.</li>
 * <li>Another folder inside the ActorGroup folder is named <code>index</code>. This folder contains an index into the journal file allowing the 
 * journal manager fast access to the most recent state record for actors. This index is used when an actor has not been 
 * loaded into memory (or was evicted) and asks the ActorGroup manager to send the actor's state back to the actor. 
 * The manager, if needed, can easily reorganize the index since it is owned and used exclusively by the manager.</li>
 * 
 * 
 * <li>In a warmed up server, it should be rare for an actor to request a state restoration since there is usually no reason for an actor to
 * be evicted except when the whole group is abandoned or when too many actors are in memory.</li>
 * <li>The resulting directory structure is <code>root/hostid/ActorGroupid/journal</code>. And <code>root/hostid/ActorGroupid/index</code></li>
 * </ul>
 */
package net.sodacan.core.journal;