/**
 * <p>A Host manages ActorGroups. A Host is the entry point for messages directed to ActorGroups contained by this Host. Messages can arrive
 * from ActorGroups within this Host, ActorGroups in other Hosts, and from external systems. </p>
 * <p>The Coordinator dynamically assigns ActorGroups to Hosts. While the Coordinator knows which ActorGroups should be active on a Host,
 * it is the host that actually manages the lifecycle of ActorGroups on that Host.</p>
 * <p>When a Host comes on-line, it reports its availability to the Coordinator. The host continues to report its availability through
 * a heartbeat function. If that heartbeat fails to be sent, such as when that host is shutdown unexpectedly, the remaining Hosts negotiate
 * to determine which Hosts will handle the lost ActorGroup(s).</p>
 * <p>When an external system sends a new message into Sodacan, it can be sent to any active host. The Host will route the message to the
 * correct Host as needed. In effect, it asks the Coordinator where the current Host for the target ActorGroup is running and sends it there.
 * Interestingly, such messages are not sent by the Host but rather is sent to the special AcrtorGroupSender. That Actor already knows 
 * how to send such messages.</p>
 * <p>It is worth mentioning that inter-host messaging is asymmetric: Messages originate from ActorGroups (actually a special ActorGroupSender within 
 * the ActorGroup). Those messages are received by the Host on another node. Message flow is described in more detail in the message package.</p>
 * <p>A host also needs to originate its own messages: When the coordinator makes a change to the configuration for a particular Host, that 
 * Host will need to update the ActorGroupSenders on that Host. The message tells the sender which Host to send messages to.</p>
 * @see net.sodacan.core.message
 */
package net.sodacan.core.host;