package net.sodacan.core.host;

import java.util.List;

import net.sodacan.core.Message;
import net.sodacan.core.Stage;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.Config;
import net.sodacan.core.Host;
/**
 * In a default host, all actorGroups are contained within the (single) host
 */
public class DefaultHost extends AbstractHost implements Host {
	private ActorGroup[] actorGroups;

	public DefaultHost(Config config) {
		super(config);
	}

	/**
	 * <p>Get things started in a host. </p>
	 * <ul>
	 * <li>Create Coordinator</li>
	 * <li>Create actorGroups</li>
	 * <li>Set initialized to true</li>
	 * <li></li>
	 * <li></li>
	 * </ul>
	 */
	@Override
	public void initialize() {
		if (isInitialized()) return;
		// Do something here
		setInitialized(true);
	}

	@Override
	public String toString() {
		return "DefaultHost: " + getHostNumber();
	}

}
