/**
 * <p>The Sodacan coordinator keeps a network-wide "ideal" distribution of ActorGroups along
 * with a snapshot of the current Host/ActorGroup arrangement.</p>
 * <p>In practice, each Host has a coordinator that communicates with other coordinators.
 * Then it's a matter of the local Coordinator working with the local Host to get the current 
 * configuration to match the ideal configuration. 
 * <b>Details: ITS EASIER SAID THAN DONE</b>
 * </p>
 * <p>While each Host has a coordinator, all coordinators endeavor to have the same view of the network. Therefore, in other parts Sodacan,
 * when the term "The Coordinator" is used, it can be thought of as a single entity even though each Host has one.</p>
 * <p>The configuration of the system can change dramatically from time to time. For example, when a Host goes off-line how
 * are the remaining nodes reconfigured to take up the slack. Likewise, when a new or existing node is brought on-line,
 * how are ActorGroups balanced to take advantage of the new resource.
 * </p>
 * <p>Sodacan's coordinators rely on Apache Zookeeper to maintain these configurations across the network and to 
 * provide services such as leader-election, heartbeat function, and change notifications.
 * </p>
 * <pre>
 * ActorGroup View
 *   ActorGroup
 *     Status Normal or Not fully replicated
 *     Backlog (inflight messages vs backpressure point)
 *     Throughput (average messages per second)
 *     Live Host
 *     Hot backup host(s)
 *     Warm backup host(s) if any
 *     Cold backup host(s) if any
 *     
 * Host View
 *   Host
 *     Off-line or On-line
 *     ActorGroups
 *       ActorGroup and Mode (live,hot,warm, cold)
 *       
 * Incident View
 *   ActorGroups not at full replication
 *   Off-line Host(s)
 *   Slow Host(s)
 *   Hosts with low storage
 *   
 * Transition View
 *   Hosts Recently off-line
 *   Hosts Recently On-line
 *   ActorGroup from Cold on Host1 to Warm on Host2 (source ActorGroup on Host3)
 *   ActorGroup from Warm on Host to Hot on Host (local journal to Actor local)
 *   ActorGroup from Hot to Live
 *      Current Live on HostA (if any) to Hot or Warm
 *      Current Hot on HostB... to Live
 *   ActorGroup from Hot to Cold on Host (No heartbeat, off-line, crash)
 *      Current Live on HostA to Cold
 *      Current Hot on HostB... to Live
 *   
 * </pre>
 * 
 */
package net.sodacan.core.coordinator;