package net.sodacan.core.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
 * <p>The TypeName annotation is optional on an ActorClass but strongly advised.
 * All actor ids contain the type of actor and a unique identifier. If the
 * type of the actor is not defined, the the actor id is defaulted to the full name of
 * the actor class. This causes several problems: </p>
 * <ul>
 * <li>The full class name is long. </li>
 * <li>The class name could change causing any messages addressing that actor to become lost.</li>
 * <li>The class name would be meaningless to a non-jvm entity.</li>
 * </ul>
 * <p>The annotation is not strictly required. Actor type name - and Actor classes can also be registered explicitly 
 * during startup.</p>
 * <p>Our actor has a public constructor. But that just allow Sodacan to construct the actor
 * as needed. You should never have to construct an actor yourself.</p>
 */
@Target(ElementType.TYPE)
@Inherited
@Retention(RetentionPolicy.RUNTIME)
public @interface ActorType {
	String name();
}
