/**
 * <p>An ActorGroup contains a dynamic number of actors. However, actors are permanently assigned to on ActorGroup. An ActorGroup has a unique id which 
 * is an integer number from 1 to 2^32-1. (Actor assignment isn't completely permanent: A social media account might be a good example. Most users have a modest 
 * amount of activity which fits nicely using random ActorGroup assignment. But there will an account that has achieved viral status and could 
 * require its own ActorGroup. Sodacan provides a way to do this using forwarding and a form of replication.)
 * </p>
 * <p>Any given ActorGroup, along with its contained Actors is only active on a single host in the network at any point in time. However, there will usually be zero or 
 * more **hot standby** replicas of the actor group. Standby ActorGroups are not used for load balancing in Sodacan. That is because Actors, by 
 * there nature, are the smallest unit of non-concurrency and require sequential access via message. As such, load balancing occurs automatically 
 * because work is by design broken into the smallest unit possible, the actor. On a big enough system or small enough information model, 
 * every actor could have its own CPU.
 * </p>
 * <p>An ActorGroup will have a primary replica running on some Host and a number of other replicas in various operating modes on other Hosts. A single Host
 * will usually have a subset of ActorGroups and each ActorGroup could be in a different operating mode on a given Host.
 * Since a single ActorGroup number can exist on more than one Host, an identifier called Host-ActorGroup is used by the Coordinator to 
 * describe the configuration of a running system.</p>
 * @see net.sodacan.core.Coordinator
 */
package net.sodacan.core.actorgroup;