/**
 * <p>A ideal actor could exist by itself with some local state, an address, its own mailbox to receive messages, and an outbox from which to send messages. 
 * In fact, from an application design perspective, that really is all that is needed.
 * </p>
 * <p>The following describes the underlying mechanisms needed to deal with the real world underneath an Actor, most of which can be 
 * ignored by the application developer. One important point to cover ere is that an Actor executes in a single thread of execution. The implication
 * is that messages line up in a queue and are processed one at a time. This also implies that when not processing a message, the actor 
 * and its state can cease to exist as long as when the next message is ready to process the Actor has the same state as it left behind since the 
 * last message was processed.
 * </p>
 * <p>Sodacan does not internally maintain a definitive directory of all Actors. Simply put, if a message is addressed to an Actor's Id, the Actor 
 * is assumed to exist. This is done to support ephemeral and special purpose Actors. Of course, if the Actor *does* have state, that state 
 * is available when needed. How that is done depends on the implementation of the Actor interface.</p>
 * <p>An Actor has four general kinds of state:</p>
 * <ul>
 * <li>LocalRecord(s) - One or more Records that are always available to the actor. They are part of commit/rollback semantics in the Actor. Sodacan considers
 * this data durable. More on that elsewhere. However, it is important to know that local Records are persisted automatically and reliably.</li>
 * <li>Foreign Record(s) - One or more Records that are read-only to this Actor but delivered to this Actor from another Actor that *does* own the Record.</li>
 * <li>Transient data - For example, local variables in Java. This kind of data is used during processing of a message. Class variables should be avoided because
 * they could be lost between messages.</li>
 * <li>Collections - A collection maintained by an Actor is just as durable as local Record storage and subject to the same commit/rollback semantics. 
 * But the underlying mechanism is a bit different because collections can grow very large. Most collections refer to other Actors, such as a Department having a list of Employees
 * that work in the Department. Large collection example: Taylor Swift's social media followers. </li>
 * </ul>
 * <p>Processing a message in an Actor goes through several phases.</p>
 * <ul>
 * <li>Instantiate - Sodacan may or may not have an instance of the Java object when the message arrives. If not, it is instantiated now. The configuration
 * allows custom Actor instantiation but in any case, Sodacan decides *when* to create the Actor instance.</li>
 * <li>RestoreState - This must be done before a message can be processed. If it's already been done from previous messages, it is not repeated.</li>
 * <li>Precheck - Precheck generally applies to messages that depend on Foreign Records: Precheck can consider the message(s) about to be processed 
 * (some messages may not need Foreign Data) 
 * and the current state of the Actor (if the Foreign Data is "new enough", an update is not needed and the message can continue through). 
 * A Precheck may cause Messages in the queue to be stalled until the required Foreign Data has arrived from the owning Actor. 
 * This can lead to Messages being processed out of order. If that is not desired, all prechecks can depend on the same Foreign Record.
 * That is all messages except the 
 * UpdateMessage carrying the updated Foreign Data.</li>
 * <li>Deserialize Payload of the message.</li>
 * <li>Message Match - Each message Match considers the type of message and the current state of the Actor and takes some action as a result. 
 * Once a message is matched, processing continues at the next phase.</li>
 * <li>State Match - Regardless of the message being processed, decisions may be needed that only depend on the current state of an actor. For example,
 * If the Actor, say a shopping cart, is in the active state and it's been a while since the last reminder has been sent to the customer, a new 
 * message can be sent.</li>
 * <li>Commit/Rollback - A go-nogo decision is made by the Actor. A rollback restores the actor to it's state before the message 
 * causing the rollback arrived.</li>
 * <li>Process the Stage - Outbound messages are serialized and sent. State is saved, serialized and sent to journal(s).</li>
 * <li>The message being processed is removed from the queue so that the next message can be considered.</li>
 * </ul>
 * <p>See the message package for more details about message flow <i>between</i> Actors.</p>
 * <p>This package contains the core and default implementations of the Actor interface.</p>
 * @see net.sodacan.core.ActorFactory
 * @see net.sodacan.core.ActorIdFactory
 * @see net.sodacan.core.message
 * @author John Churin
 *
 */
package net.sodacan.core.actor;