package net.sodacan.core.actor;

import java.util.HashMap;
import java.util.Map;

import net.sodacan.core.Actor;
import net.sodacan.core.ActorFactory;
import net.sodacan.core.ActorId;
import net.sodacan.core.SodacanException;

public class DefaultActorFactory implements ActorFactory {

	private Map<String,Class<?>> types = new HashMap<>();
	
	public void registerType(String type, Class<?> klass) {
		types.put(type, klass);
	}
	
	@Override
	public Actor createActor(ActorId actorId) {
		String actorType = actorId.getType();
		Class<?> klass = types.get(actorType);
		Actor actor;
		try {
			if (klass==null) throw new SodacanException("Unable to find actorType");
			actor = (Actor) klass.getConstructor().newInstance(actorId);
			return actor;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
}
