package net.sodacan.core.actor;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

import net.sodacan.core.Actor;
import net.sodacan.core.ActorGroup;
import net.sodacan.core.ActorId;
import net.sodacan.core.Config;
import net.sodacan.core.Message;
import net.sodacan.core.Stage;

public abstract class AbstractActor implements Actor {

	private ActorId actorId;
	private Config config;
	private ActorGroup actorGroup;
	
	private List<Message> stagedMessages = new LinkedList<>();
	
	public AbstractActor(Config config, ActorId actorId) {
		this.config = config;
		this.actorId = actorId;
	}
		
	/**
	 * <p>Empty the list of staged messages and restore the state of the actor.
	 */
	protected void rollback() {
		
	}

	@Override
	public ActorId getActorId() {
		return actorId;
	}

	@Override
	public Config getConfig() {
		return config;
	}

	@Override
	public ActorGroup getactorGroup() {
		return actorGroup;
	}

	public void setactorGroup(ActorGroup actorGroup) {
		this.actorGroup = actorGroup;
	}

	/**
	 * <p>One or more handlers can be defined in an actor.
	 * Each will be executed in order. </p>
	 * @param match If the specified matcher returns true, the the handler's function 
	 * is invoked.
	 * @param function The function to be invoked when the match function returns true.
	 * @return True if the match was successful
	 */
	protected boolean handle(Function<Message,Boolean> match, Function<Message,Boolean> function) {
		return false;
	}

//	/**
//	 * <p>Many internally defined messages don't require the application to handle them.
//	 * We take care of those messages here.</p>
//	 * <p>If this is an EventMessage, then we pop the top of the route stack in the message
//	 * thus making the to of the route stack in the message the next target. 
//	 * An actor is also free to push an additional route onto the message during 
//	 * message processing.
//	 * </p>
//	 */
//	@Override
//	public Stage processMessage(Message message) {
//		if (message instanceof EventMessage) {
//			EventMessage em = (EventMessage) message;
//			em.popRoute();
//		}
//	}

}
