package net.sodacan.core;

import java.io.Closeable;

public interface Scheduler extends Closeable {
	public Config getConfig();
	/**
	 * <p>Wait for the number of in-flight messages to go to zero. There is no assurance
	 * that the count will stay at zero.
	 * </p>
	 * <p>In production, this is used during an orderly shutdown. It is also useful
	 * during testing: Add a bunch of message, wait for the messages to clear (with this method),
	 * collect/display statistics, if desired, then exit.</p>
	 */
	public void waitForMessagesToFinish();
	/**
	 * <p>A schedulers job is to accept a message for an actorId. Create the actor
	 * and call the actor's processMessage method.</p>
	 * <p>Called from any thread. Usually delegated from actorGroup's addMessage
	 * which does more checking before the message arrives here.</p>
	 * <p>Not a good idea to call this method directly.</p>
	 * @param message The message to be processed
	 * @return True if message was accepted
	 */
	public boolean addMessage(Message message);
	public boolean addMessage(Message message, boolean force);
	public ActorGroup getActorGroup();
	public void setActorGroup(ActorGroup actorGroup);
	public void reduceMessageLoad();
	public void increaseEvictionCount();
	public void increaseMessageLoad();
	public void incrementSleepTime();
	public void increaseMessageCount();
	public int getEvictionCount();
	public int getMessageLoad();
	public int getMaxMessageLoad();
	public int getMessageCount();
	public int getSleepTime();
	public int getActorCount();
	public int getMaxThreadQueueDepth();
	public int getThreadPoolSize();
	public void evictAll();
	public void close();
}
