package net.sodacan.core;

/**
 * A message is used by the sending and receiving actor. Therefore, it is common
 * to maintain messages in a separate, independent package accessible to all parties
 * to the message interchange.
 * A message can hold more than one named payload.
 */
public interface Message {
	/**
	 * Different messages have a different way to represent the target ActorId (which 
	 * actor will receive the message).
	 * @return The target actorId of this message.
	 */
	public ActorId getTargetActorId();
}
