package net.sodacan.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.Map;

import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

import net.sodacan.core.config.DefaultConfig;

public class Main {

	static class ConfigHandler extends Handler.Abstract {
		Config config = new DefaultConfig.Builder().build();

		@Override
		public boolean handle(Request request, Response response, Callback callback) throws Exception {
		    if (!HttpMethod.GET.is(request.getMethod())) return false;
			if (!request.getHttpURI().getPath().equals("/config/")) return false;
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			config.printConfig(new PrintStream(baos));
			response.setStatus(HttpStatus.OK_200);
			Content.Sink.write(response, true, baos.toString(), callback);
			return true;
		}
	}

	static class TimeHandler extends Handler.Abstract {
		@Override
		public boolean handle(Request request, Response response, Callback callback) throws Exception {
		    if (!HttpMethod.GET.is(request.getMethod())) return false;
			if (!request.getHttpURI().getPath().equals("/time/")) return false;
			response.setStatus(HttpStatus.OK_200);
			Content.Sink.write(response, true, Instant.now().toString(), callback);
			return true;
		}
	}

	static class FancyHandler extends Handler.Abstract {
		private static UriTemplatePathSpec template = new UriTemplatePathSpec("/fancy/{number}/{string}");
		@Override
		public boolean handle(Request request, Response response, Callback callback) throws Exception {
			// Check that the method matches
			if (!HttpMethod.GET.is(request.getMethod())) return false;
		    // Decode the path and extract the parameters, if any
			String path = request.getHttpURI().getDecodedPath();
			if (!(template.matches(path))) {
				return false;
			}
			Map<String,String> params = template.getPathParams(path);
			System.out.println(params);
			// Get query strings and parse it to individual key-[value] pairs
			Fields queryFields = Request.extractQueryParameters(request);
			System.out.println(queryFields);
			
			response.setStatus(HttpStatus.OK_200);
			Content.Sink.write(response, true, params.toString() + "\n" + queryFields.toString(), callback);
			return true;
		}

	}

	public static void main(String[] args) throws Exception {

		// Create a Server instance.
		Server server = new Server();

		// Create a ServerConnector to accept connections from clients.
		ServerConnector connector = new ServerConnector(server);
		connector.setPort(8080);
		connector.setHost("127.0.0.1");
		server.addConnector(connector);

		// Setup handlers (each handler is considered until a match is found
		Handler.Sequence sequence = new Handler.Sequence();
		sequence.addHandler(new ConfigHandler());
		sequence.addHandler(new TimeHandler());
		sequence.addHandler(new FancyHandler());
		server.setHandler(sequence);

		// Start the Server to start accepting connections from clients.
		server.start();
	}
}