package net.sodacan.core;

/**
 * <p>An actorId is made up of a type, an actorGroup, and a unique id for the instance of the actor.
 * Once created, the actorId is immutable and final. </p>
 * <p>An actorfactory is able to create an actor instance given the actor id and
 * a registry (map) of actor type to actor subclass.</p>
 * The two components are separated by a "|", vertical bar.
 */
public final class ActorId {
	private String type;
	private int actorGroup;
	private String id;

	public  ActorId() {}
	
	public ActorId(String type, int actorGroup, String id) {
		this.type = type;
		this.actorGroup = actorGroup;
		this.id = id;
	}
	
	public ActorId(String type, int actorGroup, Long id) {
		this.type = type;
		this.actorGroup = actorGroup;
		this.id = Long.toString(id);
	}

	public static ActorId create(String type, int actorGroup, String id) {
		return new ActorId(type,actorGroup, id);
	}

	public static ActorId create(Class<?> clazz, int actorGroup, String id) {
		return new ActorId(clazz.getName(),actorGroup, id);
	}

	public static ActorId createFromString(String actorIdString) {
		String[] s = actorIdString.split("|");
		int actorGroup = Integer.valueOf(s[1]);
		return new ActorId(s[0],actorGroup, s[2]);
	}
	
	public String getType() {
		return type;
	}
	public String getId() {
		return id;
	}
	
	public int getActorGroup() {
		return actorGroup;
	}

	@Override
	public int hashCode() {
		return (type + id).hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj==null) return false;
		if (!(obj instanceof ActorId other)) return false;
		return (this.type.equals(other.type) 
				&& this.id.equals(other.id)
				&& this.actorGroup==other.actorGroup);
	}

	@Override
	public String toString() {
		return type + "|" + actorGroup + "|" + id;
	}

}
