package net.sodacan.core;
/**
 * <p>When it comes time to instantiate an actor, which usually happens deep in
 * the bowels of sodacan, this factory is called to do the job.</p>
 * <p>This factory is only given an ActorId to work with. Since actorId has a type parameter, the factory should use this type name
 * to determine the subclass of actor to create.
 * </p>
 *
 */
public interface ActorFactory {
	public Actor createActor(ActorId actorId);
}
