package net.sodacan.core;

/**
 * <ul>
 * <li>An actor has a unique and permanent Id.</li>
 * <li>An actor is persistent. </li>
 * <li>An actor is permanently assigned to a actorGroup</li>
 * </ul>
 * <p>The flow is straightforward:
 * When the actorGroup scheduler receives a message destined for a particular actor
 * If that actor is currently not in memory, it is constructed and the scheduler
 * sends the actor a lifecycle message.</p>
 */
public interface Actor {
	/**
	 * <p>Process one message.</p> 
	 * <p>The actor can assume that no other inbound messages or method calls
	 * will occur during processing. The actor will be running in a dedicated thread.</p>
	 * <p>The result of this </p>
	 * @param message
	 * @return A Stage object containing messages to be processed during Commit
	 */
	public Stage processMessage(Message message);

	public ActorId getActorId();
	public Config getConfig();
	public ActorGroup getactorGroup();

}
