/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.Locale;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class IntegerOption
extends Option<Integer> {
    public IntegerOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, true, minCount, maxCount);
    }

    public IntegerOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, true, mandatory, allowMany);
    }

    @Override
    protected Integer parseValue(String arg, Locale locale) throws OptionException {
        try {
            return Integer.valueOf(arg);
        }
        catch (NumberFormatException nfx) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg).withCause(nfx);
        }
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

