/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.ResourceBundle;
import snaq.util.jclap.StringOption;

public class FileOption
extends StringOption {
    public FileOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, minCount, maxCount);
    }

    public FileOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, mandatory, allowMany);
    }

    @Override
    protected String getUsageTypeString(ResourceBundle res) {
        Objects.requireNonNull(res);
        FileFilter f = (FileFilter)this.getFilter().orElse(s -> true);
        String type = null;
        switch (f.fType) {
            case ACCEPT_FILE: {
                type = "file";
                break;
            }
            case ACCEPT_DIR: {
                type = "dir";
                break;
            }
            default: {
                type = "all";
            }
        }
        return res.getString("option.type.String.file." + type);
    }

    public static final class FileFilter
    implements StringOption.Filter {
        private AcceptExistance eType = AcceptExistance.ACCEPT_ALL;
        private AcceptFileType fType = AcceptFileType.ACCEPT_ALL;

        public FileFilter(AcceptExistance eType, AcceptFileType fType) {
            this.eType = eType;
            this.fType = fType;
        }

        @Override
        public boolean accept(String arg) {
            try {
                File f = new File(arg).getCanonicalFile();
                switch (this.eType) {
                    case ACCEPT_NON_EXISTING: {
                        if (!f.exists()) break;
                        return false;
                    }
                    case ACCEPT_EXISTING: {
                        if (f.exists()) break;
                        return false;
                    }
                }
                switch (this.fType) {
                    case ACCEPT_DIR: {
                        if (f.isDirectory()) break;
                        return false;
                    }
                    case ACCEPT_FILE: {
                        if (f.isFile()) break;
                        return false;
                    }
                    case ACCEPT_ALL: {
                        if (!f.isFile() && !f.isDirectory()) break;
                        return true;
                    }
                }
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }

        public static enum AcceptFileType {
            ACCEPT_FILE,
            ACCEPT_DIR,
            ACCEPT_ALL;

        }

        public static enum AcceptExistance {
            ACCEPT_EXISTING,
            ACCEPT_NON_EXISTING,
            ACCEPT_ALL;

        }
    }
}

