/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class LocalDateOption
extends Option<LocalDate> {
    private DateTimeFormatter dtf = null;

    public LocalDateOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, true, mandatory, allowMany);
    }

    public LocalDateOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, true, minCount, maxCount);
    }

    @Override
    public Class<LocalDate> getType() {
        return LocalDate.class;
    }

    @Override
    protected LocalDate parseValue(String arg, Locale locale) throws OptionException {
        if (arg == null) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        try {
            DateTimeFormatter df = this.dtf != null ? this.dtf.withLocale(locale) : DateTimeFormatter.ISO_LOCAL_DATE.withLocale(locale);
            return LocalDate.parse(arg, df);
        }
        catch (DateTimeParseException px) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this).withCause(px);
        }
    }

    public void setDateFormat(DateTimeFormatter dtf) {
        this.dtf = dtf;
    }

    public DateTimeFormatter getDateFormat(Locale locale) {
        if (this.dtf != null) {
            return this.dtf.withLocale(locale);
        }
        return DateTimeFormatter.ISO_LOCAL_DATE.withLocale(locale);
    }
}

