/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import snaq.util.jclap.EnumeratedOption;
import snaq.util.jclap.OptionException;

public final class EnumeratedStringOption
extends EnumeratedOption<String> {
    private boolean ignoreCase = true;

    public EnumeratedStringOption(String shortName, String longName, String description, int minCount, int maxCount, Collection<String> allowedValues, boolean ignoreCase) {
        super(shortName, longName, description, minCount, maxCount, allowedValues);
        this.ignoreCase = ignoreCase;
    }

    public EnumeratedStringOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, Collection<String> allowedValues, boolean ignoreCase) {
        super(shortName, longName, description, mandatory, allowMany, allowedValues);
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean isValueValid(String value, Locale locale) {
        try {
            return this.parseValue(value, locale) != null;
        }
        catch (OptionException ex) {
            return false;
        }
    }

    @Override
    protected String parseValue(String arg, Locale locale) throws OptionException {
        List vals = this.getAllowedValues().stream().filter(x -> x.toLowerCase(locale).contains(arg)).collect(Collectors.toList());
        if (vals.isEmpty()) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        if (vals.size() > 1 && ((vals = vals.stream().filter(x -> x.contains(arg)).collect(Collectors.toList())).isEmpty() || vals.size() > 1)) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        return (String)vals.get(0);
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public String getAllowedValuesString() {
        return this.getAllowedValuesString("\"", "\"", ", ");
    }
}

