/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import snaq.util.jclap.CLAParser;
import snaq.util.jclap.OptionException;

public abstract class Option<E> {
    static final String REGEX_SHORT_NAME = "[A-Za-z\\d@?]";
    static final String REGEX_LONG_NAME = "[A-Za-z\\d][A-Za-z\\d-]*[A-Za-z\\d]";
    protected static final int MIN_COUNT_LIMIT = 0;
    protected static final int MAX_COUNT_LIMIT = 100;
    protected static final Locale LOCALE = CLAParser.getDefaultLocale();
    protected static final ResourceBundle BUNDLE = CLAParser.getDefaultResources();
    private String shortName;
    private String longName;
    private String description;
    private boolean requiresValue = false;
    private int minCount = 0;
    private int maxCount = 100;
    private final List<E> values = new ArrayList();
    private boolean hideFromUsage = false;

    protected Option(String shortName, String longName, String description, boolean requiresValue, int minCount, int maxCount) {
        if (shortName == null) {
            throw new IllegalArgumentException(BUNDLE.getString("err.NullShortName"));
        }
        if (!shortName.matches(REGEX_SHORT_NAME)) {
            throw new IllegalArgumentException(BUNDLE.getString("err.BadShortName"));
        }
        if (longName != null && !longName.matches(REGEX_LONG_NAME)) {
            throw new IllegalArgumentException(BUNDLE.getString("err.BadLongName"));
        }
        if (minCount < 0) {
            throw new IllegalArgumentException(BUNDLE.getString("err.InvalidMinCount"));
        }
        if (maxCount < minCount || maxCount > 100) {
            throw new IllegalArgumentException(BUNDLE.getString("err.InvalidMaxCount"));
        }
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.requiresValue = requiresValue;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    protected Option(String shortName, String longName, String description, boolean requiresValue, boolean mandatory, boolean allowMany) {
        this(shortName, longName, description, requiresValue, mandatory ? 1 : 0, allowMany ? 100 : 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        if (this.requiresValue != other.requiresValue) {
            return false;
        }
        if (this.minCount != other.minCount) {
            return false;
        }
        if (this.maxCount != other.maxCount) {
            return false;
        }
        if (this.hideFromUsage != other.hideFromUsage) {
            return false;
        }
        if (!Objects.equals(this.shortName, other.shortName)) {
            return false;
        }
        if (!Objects.equals(this.longName, other.longName)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.values, other.values);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.shortName);
        hash = 97 * hash + Objects.hashCode(this.longName);
        hash = 97 * hash + Objects.hashCode(this.description);
        hash = 97 * hash + (this.requiresValue ? 1 : 0);
        hash = 97 * hash + this.minCount;
        hash = 97 * hash + this.maxCount;
        hash = 97 * hash + Objects.hashCode(this.values);
        hash = 97 * hash + (this.hideFromUsage ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[-");
        sb.append(this.shortName);
        if (this.longName != null) {
            sb.append(",--");
            sb.append(this.longName);
        }
        sb.append(",");
        sb.append(this.getType().getName());
        sb.append("]");
        return sb.toString();
    }

    public abstract Class<E> getType();

    String getUsageTypeString(ResourceBundle res) {
        Objects.requireNonNull(res);
        String valType = this.getType().getName();
        valType = valType.substring(valType.lastIndexOf(46) + 1);
        String usageType = null;
        try {
            usageType = res.getString("option.type." + valType);
        }
        catch (MissingResourceException mrx) {
            usageType = res.getString("option.type.unknown");
        }
        return usageType;
    }

    public List<E> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    protected void addValue(E value) throws OptionException {
        if (this.maxCount == 0) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, value.toString());
        }
        if (this.maxCount == 1 && !this.values.isEmpty()) {
            throw new OptionException(OptionException.Type.OPTION_HAS_VALUE, this, value.toString());
        }
        if (this.values.size() >= this.maxCount) {
            throw new OptionException(OptionException.Type.INVALID_OPTION_VALUE_COUNT, this, value.toString());
        }
        this.values.add(value);
    }

    protected abstract E parseValue(String var1, Locale var2) throws OptionException;

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public boolean isMandatory() {
        return this.minCount > 0;
    }

    public boolean isAllowMany() {
        return this.maxCount > 1;
    }

    public void setMinMaxCounts(int minCount, int maxCount) {
        if (minCount < 0) {
            throw new IllegalArgumentException(BUNDLE.getString("err.InvalidMinCount"));
        }
        if (maxCount < minCount || maxCount > 100) {
            throw new IllegalArgumentException(BUNDLE.getString("err.InvalidMaxCount"));
        }
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public Option<E> setHidden() {
        this.hideFromUsage = true;
        return this;
    }

    public boolean isHidden() {
        return this.hideFromUsage;
    }
}

