/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import snaq.util.jclap.Option;

public abstract class EnumeratedOption<E>
extends Option<E> {
    private Collection<E> allowedValues;

    public EnumeratedOption(String shortName, String longName, String description, int minCount, int maxCount, Collection<E> allowedValues) {
        super(shortName, longName, description, true, minCount, maxCount);
        this.allowedValues = allowedValues;
    }

    public EnumeratedOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, Collection<E> allowedValues) {
        super(shortName, longName, description, true, mandatory, allowMany);
        this.allowedValues = allowedValues;
    }

    public boolean isValueValid(E value) {
        for (E av : this.allowedValues) {
            if (!av.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Collection<E> getAllowedValues() {
        return Collections.unmodifiableCollection(this.allowedValues);
    }

    public String getAllowedValuesString(String prefix, String suffix, String separator) {
        return this.allowedValues.stream().map(s -> prefix + s + suffix).collect(Collectors.joining(separator));
    }

    public String getAllowedValuesString() {
        return this.getAllowedValuesString("", "", ", ");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[-");
        sb.append(this.getShortName());
        if (this.getLongName() != null) {
            sb.append(",--");
            sb.append(this.getLongName());
        }
        sb.append(",");
        sb.append(this.getType().getName());
        sb.append(",{");
        Iterator<E> iter = this.allowedValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(' ');
        }
        sb.append("}]");
        return sb.toString();
    }
}

