/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import snaq.util.jclap.BooleanOption;
import snaq.util.jclap.DoubleOption;
import snaq.util.jclap.EnumeratedIntegerOption;
import snaq.util.jclap.EnumeratedOption;
import snaq.util.jclap.EnumeratedStringOption;
import snaq.util.jclap.FileOption;
import snaq.util.jclap.FloatOption;
import snaq.util.jclap.IntegerOption;
import snaq.util.jclap.LocalDateOption;
import snaq.util.jclap.LongOption;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;
import snaq.util.jclap.StringOption;

public final class CLAParser {
    private static final boolean DEBUG = false;
    private static final int INIT_MAP_SIZE = 8;
    private static final Locale LOCALE = Locale.getDefault();
    private final Locale locale;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(CLAParser.class.getName(), LOCALE);
    private final ResourceBundle bundle;
    private boolean showLongNamesInShortUsage = false;
    private final List<Option> options = new ArrayList<Option>(8);
    private List<String> nonOptionArgs = null;

    public CLAParser(Locale locale) {
        this.locale = locale;
        this.bundle = ResourceBundle.getBundle(CLAParser.class.getName(), locale);
    }

    public CLAParser() {
        this(Locale.getDefault());
    }

    static Locale getDefaultLocale() {
        return LOCALE;
    }

    Locale getLocale() {
        return this.locale;
    }

    static ResourceBundle getDefaultResources() {
        return BUNDLE;
    }

    ResourceBundle getResources() {
        return this.bundle;
    }

    public void showLongNamesInShortUsage() {
        this.showLongNamesInShortUsage = true;
    }

    public boolean parsedSolitaryHyphen() {
        return this.nonOptionArgs.stream().anyMatch(x -> "-".equals(x));
    }

    public <T> Option<T> addOption(Option<T> opt) {
        Objects.requireNonNull(opt);
        for (Option o : this.options) {
            String optSN = opt.getShortName();
            String optLN = opt.getLongName();
            String oLN = o.getLongName();
            if (o.getShortName().equals(optSN)) {
                throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("err.OptionNameInUse"), optSN));
            }
            if (oLN == null || optLN == null || !oLN.equals(optLN)) continue;
            throw new IllegalArgumentException(MessageFormat.format(BUNDLE.getString("err.OptionNameInUse"), optLN));
        }
        this.options.add(opt);
        return opt;
    }

    public void setHidden(String optionName) throws OptionException {
        Option opt = this.getOptionByShortName(optionName);
        if (opt == null) {
            opt = this.getOptionByLongName(optionName);
        }
        if (opt == null) {
            throw new OptionException(OptionException.Type.UNKNOWN_OPTION, optionName);
        }
        opt.setHidden();
    }

    public Option<Boolean> addBooleanOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new BooleanOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<Boolean> addBooleanOption(String shortName, String longName, String description, boolean allowMany) {
        return this.addOption(new BooleanOption(shortName, longName, description, allowMany));
    }

    public Option<Boolean> addBooleanOption(String shortName, String longName, String description, int maxCount) {
        return this.addOption(new BooleanOption(shortName, longName, description, 0, maxCount));
    }

    public Option<Boolean> addBooleanOption(String shortName, String longName, String description) {
        return this.addBooleanOption(shortName, longName, description, false);
    }

    public Option<Boolean> addBooleanOption(String shortName, boolean allowMany) {
        return this.addOption(new BooleanOption(shortName, null, null, allowMany));
    }

    public Option<Boolean> addBooleanOption(String shortName, int maxCount) {
        return this.addOption(new BooleanOption(shortName, null, null, 0, maxCount));
    }

    public Option<Boolean> addBooleanOption(String shortName) {
        return this.addBooleanOption(shortName, false);
    }

    public Option<Integer> addIntegerOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addOption(new IntegerOption(shortName, longName, description, mandatory, allowMany));
    }

    public Option<Integer> addIntegerOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new IntegerOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<Integer> addIntegerOption(String shortName, boolean mandatory, boolean allowMany) {
        return this.addOption(new IntegerOption(shortName, null, null, mandatory, allowMany));
    }

    public Option<Integer> addIntegerOption(String shortName, int minCount, int maxCount) {
        return this.addOption(new IntegerOption(shortName, null, null, minCount, maxCount));
    }

    public Option<Long> addLongOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addOption(new LongOption(shortName, longName, description, mandatory, allowMany));
    }

    public Option<Long> addLongOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new LongOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<Long> addLongOption(String shortName, boolean mandatory, boolean allowMany) {
        return this.addOption(new LongOption(shortName, null, null, mandatory, allowMany));
    }

    public Option<Long> addLongOption(String shortName, int minCount, int maxCount) {
        return this.addOption(new LongOption(shortName, null, null, minCount, maxCount));
    }

    public Option<Double> addDoubleOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addOption(new DoubleOption(shortName, longName, description, mandatory, allowMany));
    }

    public Option<Double> addDoubleOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new DoubleOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<Double> addDoubleOption(String shortName, boolean mandatory, boolean allowMany) {
        return this.addOption(new DoubleOption(shortName, null, null, mandatory, allowMany));
    }

    public Option<Double> addDoubleOption(String shortName, int minCount, int maxCount) {
        return this.addOption(new DoubleOption(shortName, null, null, minCount, maxCount));
    }

    public Option<Float> addFloatOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addOption(new FloatOption(shortName, longName, description, mandatory, allowMany));
    }

    public Option<Float> addFloatOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new FloatOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<Float> addFloatOption(String shortName, boolean mandatory, boolean allowMany) {
        return this.addOption(new FloatOption(shortName, null, null, mandatory, allowMany));
    }

    public Option<Float> addFloatOption(String shortName, int minCount, int maxCount) {
        return this.addOption(new FloatOption(shortName, null, null, minCount, maxCount));
    }

    public Option<String> addStringOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addOption(new StringOption(shortName, longName, description, mandatory, allowMany));
    }

    public Option<String> addStringOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new StringOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<String> addStringOption(String shortName, String longName, String description) {
        return this.addOption(new StringOption(shortName, longName, description, false, false));
    }

    public Option<String> addStringOption(String shortName, boolean mandatory, boolean allowMany) {
        return this.addOption(new StringOption(shortName, null, null, mandatory, allowMany));
    }

    public Option<String> addStringOption(String shortName, int minCount, int maxCount) {
        return this.addOption(new StringOption(shortName, null, null, minCount, maxCount));
    }

    public Option<String> addFileOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        FileOption opt = new FileOption(shortName, longName, description, mandatory, allowMany);
        FileOption.FileFilter.AcceptExistance eType = FileOption.FileFilter.AcceptExistance.ACCEPT_ALL;
        FileOption.FileFilter.AcceptFileType fType = FileOption.FileFilter.AcceptFileType.ACCEPT_ALL;
        FileOption.FileFilter filter = new FileOption.FileFilter(eType, fType);
        opt.setFilter(filter);
        return this.addOption(opt);
    }

    public Option<String> addFileNewOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        FileOption opt = new FileOption(shortName, longName, description, mandatory, allowMany);
        FileOption.FileFilter.AcceptExistance eType = FileOption.FileFilter.AcceptExistance.ACCEPT_NON_EXISTING;
        FileOption.FileFilter.AcceptFileType fType = FileOption.FileFilter.AcceptFileType.ACCEPT_ALL;
        FileOption.FileFilter filter = new FileOption.FileFilter(eType, fType);
        opt.setFilter(filter);
        return this.addOption(opt);
    }

    public Option<String> addFileExistingOption(String shortName, String longName, String description, int minCount, int maxCount) {
        FileOption opt = new FileOption(shortName, longName, description, minCount, maxCount);
        FileOption.FileFilter.AcceptExistance eType = FileOption.FileFilter.AcceptExistance.ACCEPT_EXISTING;
        FileOption.FileFilter.AcceptFileType fType = FileOption.FileFilter.AcceptFileType.ACCEPT_FILE;
        FileOption.FileFilter filter = new FileOption.FileFilter(eType, fType);
        opt.setFilter(filter);
        return this.addOption(opt);
    }

    public Option<String> addFileExistingOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addFileExistingOption(shortName, longName, description, mandatory ? 1 : 0, allowMany ? 100 : 1);
    }

    public Option<String> addFolderExistingOption(String shortName, String longName, String description, int minCount, int maxCount) {
        FileOption opt = new FileOption(shortName, longName, description, minCount, maxCount);
        FileOption.FileFilter.AcceptExistance eType = FileOption.FileFilter.AcceptExistance.ACCEPT_EXISTING;
        FileOption.FileFilter.AcceptFileType fType = FileOption.FileFilter.AcceptFileType.ACCEPT_DIR;
        FileOption.FileFilter filter = new FileOption.FileFilter(eType, fType);
        opt.setFilter(filter);
        return this.addOption(opt);
    }

    public Option<String> addFolderExistingOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addFolderExistingOption(shortName, longName, description, mandatory ? 1 : 0, allowMany ? 100 : 1);
    }

    public Option<String> addEnumStringOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, String[] allowedValues, boolean ignoreCase) {
        ArrayList<String> x = new ArrayList<String>();
        x.addAll(Arrays.asList(allowedValues));
        return this.addOption(new EnumeratedStringOption(shortName, longName, description, mandatory, allowMany, x, ignoreCase));
    }

    public Option<String> addEnumStringOption(String shortName, String longName, String description, int minCount, int maxCount, String[] allowedValues, boolean ignoreCase) {
        ArrayList<String> x = new ArrayList<String>();
        x.addAll(Arrays.asList(allowedValues));
        return this.addOption(new EnumeratedStringOption(shortName, longName, description, minCount, maxCount, x, ignoreCase));
    }

    public Option<String> addEnumStringOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, String[] allowedValues) {
        return this.addEnumStringOption(shortName, longName, description, mandatory, allowMany, allowedValues, true);
    }

    public Option<String> addEnumStringOption(String shortName, String longName, String description, String[] allowedValues) {
        return this.addEnumStringOption(shortName, longName, description, false, false, allowedValues);
    }

    public Option<Integer> addEnumIntegerOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, int[] allowedValues) {
        ArrayList<Integer> x = new ArrayList<Integer>();
        int[] nArray = allowedValues;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer s = nArray[i];
            x.add(s);
        }
        return this.addOption(new EnumeratedIntegerOption(shortName, longName, description, mandatory, allowMany, (Collection<Integer>)x));
    }

    public Option<Integer> addEnumIntegerOption(String shortName, String longName, String description, int[] allowedValues) {
        return this.addEnumIntegerOption(shortName, longName, description, false, false, allowedValues);
    }

    public Option<LocalDate> addLocalDateOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        return this.addOption(new LocalDateOption(shortName, longName, description, mandatory, allowMany));
    }

    public Option<LocalDate> addLocalDateOption(String shortName, String longName, String description, int minCount, int maxCount) {
        return this.addOption(new LocalDateOption(shortName, longName, description, minCount, maxCount));
    }

    public Option<LocalDate> addLocalDateOption(String shortName, String longName, String description) {
        return this.addOption(new LocalDateOption(shortName, longName, description, false, false));
    }

    public Option<LocalDate> addLocalDateOption(String shortName, boolean mandatory, boolean allowMany) {
        return this.addOption(new LocalDateOption(shortName, null, null, mandatory, allowMany));
    }

    public Option<LocalDate> addLocalDateOption(String shortName, int minCount, int maxCount) {
        return this.addOption(new LocalDateOption(shortName, null, null, minCount, maxCount));
    }

    private Option getOptionByShortName(String shortName) {
        if (shortName == null || "".equals(shortName)) {
            throw new IllegalArgumentException();
        }
        for (Option o : this.options) {
            if (!shortName.equals(o.getShortName())) continue;
            return o;
        }
        return null;
    }

    private Option getOptionByShortName(char shortName) {
        return this.getOptionByShortName(new String(new char[]{shortName}));
    }

    private Option getOptionByLongName(String longName) {
        if (longName == null || "".equals(longName)) {
            throw new IllegalArgumentException();
        }
        for (Option o : this.options) {
            if (!longName.equals(o.getLongName())) continue;
            return o;
        }
        return null;
    }

    public <T> Option<T> getOption(String optionName, Class<T> type) throws OptionException {
        if (optionName == null) {
            throw new OptionException(OptionException.Type.UNKNOWN_OPTION, optionName);
        }
        Option opt = null;
        if (optionName.length() == 1) {
            opt = this.getOptionByShortName(optionName);
        }
        if (opt == null) {
            opt = this.getOptionByLongName(optionName);
        }
        if (opt == null) {
            throw new OptionException(OptionException.Type.UNKNOWN_OPTION, optionName);
        }
        if (type == null || !type.equals(opt.getType())) {
            throw new OptionException(OptionException.Type.INVALID_OPTION_TYPE, optionName);
        }
        return opt;
    }

    public List<Option> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    public <T> List<T> getOptionValues(Option<T> opt) throws OptionException {
        if (opt == null) {
            throw new OptionException(OptionException.Type.UNKNOWN_OPTION, opt);
        }
        return Collections.unmodifiableList(opt.getValues());
    }

    public <T> List<T> getOptionValues(String optionName, Class<T> type) throws OptionException {
        return this.getOptionValues(this.getOption(optionName, type));
    }

    public <T> T getOptionValue(Option<T> opt) throws OptionException {
        if (opt == null) {
            throw new OptionException(OptionException.Type.UNKNOWN_OPTION, opt);
        }
        if (opt.isAllowMany()) {
            throw new OptionException(OptionException.Type.INVALID_RETRIEVAL_TYPE, opt);
        }
        List<T> vals = this.getOptionValues(opt);
        return vals.isEmpty() ? null : (T)vals.get(0);
    }

    public <T> T getOptionValue(Option<T> opt, T def) throws OptionException {
        EnumeratedOption eo;
        if (opt == null) {
            throw new OptionException(OptionException.Type.UNKNOWN_OPTION, opt);
        }
        if (opt.isAllowMany()) {
            throw new OptionException(OptionException.Type.INVALID_RETRIEVAL_TYPE, opt);
        }
        if (opt instanceof EnumeratedOption && !(eo = (EnumeratedOption)opt).isValueValid(def)) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt, def.toString());
        }
        List<T> vals = this.getOptionValues(opt);
        return vals.isEmpty() ? def : vals.get(0);
    }

    public <T> T getOptionValue(String optionName, Class<T> type, T def) throws OptionException {
        return this.getOptionValue(this.getOption(optionName, type), def);
    }

    public <T> T getOptionValue(String optionName, Class<T> type) throws OptionException {
        return this.getOptionValue(optionName, type, null);
    }

    public List<Boolean> getBooleanOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, Boolean.class);
    }

    public Boolean getBooleanOptionValue(String optionName, Boolean def) throws OptionException {
        return this.getOptionValue(optionName, Boolean.class, def);
    }

    public Boolean getBooleanOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, Boolean.class, Boolean.FALSE);
    }

    public List<Integer> getIntegerOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, Integer.class);
    }

    public Integer getIntegerOptionValue(String optionName, Integer def) throws OptionException {
        return this.getOptionValue(optionName, Integer.class, def);
    }

    public Integer getIntegerOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, Integer.class);
    }

    public List<Long> getLongOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, Long.class);
    }

    public Long getLongOptionValue(String optionName, Long def) throws OptionException {
        return this.getOptionValue(optionName, Long.class, def);
    }

    public Long getLongOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, Long.class);
    }

    public List<Double> getDoubleOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, Double.class);
    }

    public Double getDoubleOptionValue(String optionName, Double def) throws OptionException {
        return this.getOptionValue(optionName, Double.class, def);
    }

    public Double getDoubleOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, Double.class);
    }

    public List<Float> getFloatOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, Float.class);
    }

    public Float getFloatOptionValue(String optionName, Float def) throws OptionException {
        return this.getOptionValue(optionName, Float.class, def);
    }

    public Float getFloatOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, Float.class);
    }

    public List<String> getStringOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, String.class);
    }

    public String getStringOptionValue(String optionName, String def) throws OptionException {
        return this.getOptionValue(optionName, String.class, def);
    }

    public String getStringOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, String.class);
    }

    public List<LocalDate> getLocalDateOptionValues(String optionName) throws OptionException {
        return this.getOptionValues(optionName, LocalDate.class);
    }

    public LocalDate getLocalDateOptionValue(String optionName, LocalDate def) throws OptionException {
        return this.getOptionValue(optionName, LocalDate.class, def);
    }

    public LocalDate getLocalDateOptionValue(String optionName) throws OptionException {
        return this.getOptionValue(optionName, LocalDate.class);
    }

    public List<File> getFileOptionValues(String optionName) throws OptionException {
        List<String> ov = this.getOptionValues(optionName, String.class);
        ArrayList<File> list = new ArrayList<File>();
        try {
            for (String s : ov) {
                list.add(new File(s).getCanonicalFile());
            }
        }
        catch (IOException ex) {
            Option<String> opt = this.getOption(optionName, String.class);
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt);
        }
        return list;
    }

    public File getFileOptionValue(String optionName, File def) throws OptionException {
        String ov = this.getOptionValue(optionName, String.class);
        try {
            return ov == null ? def : new File(ov).getCanonicalFile();
        }
        catch (IOException ex) {
            Option<String> opt = this.getOption(optionName, String.class);
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt, ov);
        }
    }

    public File getFileOptionValue(String optionName) throws OptionException {
        String ov = this.getOptionValue(optionName, String.class);
        try {
            return ov == null ? null : new File(ov).getCanonicalFile();
        }
        catch (IOException ex) {
            Option<String> opt = this.getOption(optionName, String.class);
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt, ov);
        }
    }

    public List<String> getNonOptionArguments() {
        return Collections.unmodifiableList(this.nonOptionArgs);
    }

    public void parse(String[] args) throws OptionException {
        ArrayList<String> spareArgs = new ArrayList<String>();
        ArrayList<String> list = new ArrayList<String>(args.length);
        list.addAll(Arrays.asList(args));
        String regexFlags = this.options.stream().filter(o -> Boolean.class.equals(o.getType())).map(o -> o.getShortName()).collect(Collectors.joining()).replace("?", "\\?").replaceFirst("(.+)", "[$1]+");
        String regexNonFlag = this.options.stream().filter(o -> !Boolean.class.equals(o.getType())).filter(o -> o.requiresValue()).map(o -> o.getShortName()).collect(Collectors.joining()).replace("?", "\\?").replaceFirst("(.+)", "[$1]");
        String op1 = String.format("^--(%s)(?:[=:]([^\\s]+))?$", "[A-Za-z\\d][A-Za-z\\d-]*[A-Za-z\\d]");
        String op2 = String.format("^[-/](%s)(%s)(?:[=:]?([^\\s]+))$", regexFlags, regexNonFlag);
        String op3 = String.format("^[-/](%s)$", regexFlags);
        String op4 = String.format("^[-/](%s)(?:[=:]?([^\\s]+))?$", "[A-Za-z\\d@?]");
        Pattern optPattern1 = Pattern.compile(op1);
        Pattern optPattern2 = Pattern.compile(op2);
        Pattern optPattern3 = Pattern.compile(op3);
        Pattern optPattern4 = Pattern.compile(op4);
        boolean eoo = false;
        ListIterator<String> iter = list.listIterator();
        while (iter.hasNext()) {
            Option opt;
            String flagSN;
            String flagNames;
            Option opt2;
            String arg = (String)iter.next();
            if (eoo || "-".equals(arg)) {
                spareArgs.add(arg);
                continue;
            }
            if (arg.equals("--")) {
                eoo = true;
                continue;
            }
            Matcher m1 = optPattern1.matcher(arg);
            Matcher m2 = optPattern2.matcher(arg);
            Matcher m3 = optPattern3.matcher(arg);
            Matcher m4 = optPattern4.matcher(arg);
            if (m1.matches()) {
                opt2 = this.getOptionByLongName(m1.group(1));
                if (opt2 == null) {
                    throw new OptionException(OptionException.Type.UNKNOWN_OPTION, m1.group(1));
                }
                this.processOptionValue(opt2, m1.group(2), iter);
                continue;
            }
            if (m2.matches()) {
                flagNames = m2.group(1);
                for (int i = 0; i < flagNames.length(); ++i) {
                    flagSN = flagNames.substring(i, i + 1);
                    opt = this.getOptionByShortName(flagSN);
                    if (opt == null) {
                        throw new OptionException(OptionException.Type.UNKNOWN_OPTION, flagSN);
                    }
                    if (opt.requiresValue()) {
                        throw new OptionException(OptionException.Type.NOT_FLAG, opt.getShortName(), flagSN);
                    }
                    opt.addValue(Boolean.TRUE);
                }
                Option opt3 = this.getOptionByShortName(m2.group(2));
                if (opt3 == null) {
                    throw new OptionException(OptionException.Type.UNKNOWN_OPTION, m2.group(1));
                }
                this.processOptionValue(opt3, m2.group(3), iter);
                continue;
            }
            if (m3.matches()) {
                flagNames = m3.group(1);
                for (int i = 0; i < flagNames.length(); ++i) {
                    flagSN = flagNames.substring(i, i + 1);
                    opt = this.getOptionByShortName(flagSN);
                    if (opt == null) {
                        throw new OptionException(OptionException.Type.UNKNOWN_OPTION, flagSN);
                    }
                    if (opt.requiresValue()) {
                        throw new OptionException(OptionException.Type.NOT_FLAG, opt.getShortName(), flagSN);
                    }
                    opt.addValue(Boolean.TRUE);
                }
                continue;
            }
            if (m4.matches()) {
                opt2 = this.getOptionByShortName(m4.group(1));
                if (opt2 == null) {
                    throw new OptionException(OptionException.Type.UNKNOWN_OPTION, m4.group(1));
                }
                this.processOptionValue(opt2, m4.group(2), iter);
                continue;
            }
            spareArgs.add(arg);
        }
        this.nonOptionArgs = spareArgs;
        for (Option opt : this.options) {
            int valCount = opt.getValues().size();
            if (opt.isMandatory() && opt.getValues().isEmpty()) {
                throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt, null);
            }
            if (valCount >= opt.getMinCount() && valCount <= opt.getMaxCount()) continue;
            throw new OptionException(OptionException.Type.INVALID_OPTION_COUNT, opt, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOptionValue(Option opt, String val, ListIterator<String> iter) throws OptionException {
        if (val != null) {
            if (!opt.requiresValue() && (!Boolean.class.equals(opt.getType()) || !opt.isAllowMany() || opt.getValues().size() >= opt.getMaxCount())) throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt);
            opt.addValue(opt.parseValue(val, this.getLocale()));
            return;
        } else if (opt.requiresValue()) {
            if (!iter.hasNext()) throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, opt, "null");
            opt.addValue(opt.parseValue(iter.next(), this.getLocale()));
            return;
        } else {
            if (!opt.getType().equals(Boolean.class)) return;
            opt.addValue(Boolean.TRUE);
        }
    }

    private static String getLaunchCmd() {
        String launchCmd = null;
        String cp = System.getProperty("java.class.path");
        if (Pattern.matches("^[^\\?%*:|\"<>]+\\.jar$", cp)) {
            launchCmd = "java -jar " + cp;
        } else {
            Exception ex = new Exception();
            StackTraceElement[] st = ex.getStackTrace();
            for (int i = 2; i < st.length; ++i) {
                if (!st[i].getMethodName().equals("main")) continue;
                launchCmd = "java " + st[i].getClassName();
            }
        }
        return launchCmd != null ? launchCmd : "java App";
    }

    public void printUsage(PrintStream ps, boolean longUsage) {
        this.printUsage(ps, longUsage, null, null, null);
    }

    @Deprecated
    public void printUsage(PrintStream ps, boolean longUsage, String suffixArgs) {
        this.printUsage(ps, longUsage, null, suffixArgs, null);
    }

    @Deprecated
    public void printUsage(PrintStream ps, boolean longUsage, String appString, String suffixArgs) {
        this.printUsage(ps, longUsage, appString, suffixArgs, null);
    }

    public void printUsage(PrintStream ps, boolean longUsage, String appString, String suffixArgs, String extraInfo) {
        String lSep = System.getProperty("line.separator");
        ResourceBundle res = this.bundle != null ? this.bundle : BUNDLE;
        String appLaunch = appString == null ? CLAParser.getLaunchCmd() : appString;
        String ver = longUsage ? "long" : "short";
        StringBuilder sbOpt = new StringBuilder();
        String fmUsageOption = res.getString("option." + ver + ".mandatory").replace("\n", lSep);
        String fmUsageOptionO = res.getString("option." + ver).replace("\n", lSep);
        for (Option option : this.options) {
            String desc;
            if (option.isHidden()) continue;
            boolean hasLongName = option.getLongName() != null;
            String optValType = option.getType().getName().replaceFirst(".+\\.", "");
            String typeFormat = "usage.type." + optValType;
            if (!hasLongName || !longUsage && !this.showLongNamesInShortUsage) {
                typeFormat = typeFormat + ".simple";
            }
            try {
                typeFormat = res.getString(typeFormat);
            }
            catch (MissingResourceException mrx) {
                typeFormat = "usage.type.unknown";
                if (!hasLongName || !longUsage) {
                    typeFormat = typeFormat + ".simple";
                }
                typeFormat = res.getString(typeFormat).replace("\n", lSep);
            }
            Object[] args = new String[]{option.getShortName(), option.getLongName(), option.getUsageTypeString(res)};
            String mUsageType = MessageFormat.format(typeFormat, args);
            String string = longUsage ? (option.getDescription() != null ? option.getDescription() + lSep : "") : (desc = "");
            if (option instanceof EnumeratedOption) {
                String enumDescFormat = res.getString("option.description.enum").replace("\n", lSep);
                EnumeratedOption eo = (EnumeratedOption)option;
                String enumString = eo.getAllowedValuesString();
                args = new String[]{enumString, desc};
                desc = MessageFormat.format(enumDescFormat, args);
            }
            if (option instanceof LocalDateOption) {
                LocalDateOption ldo = (LocalDateOption)option;
                String descFormat = res.getString("option.description.LocalDate").replace("\n", lSep);
                args = new String[]{ldo.getDateFormat(this.getLocale()).format(LocalDate.now()), desc};
                desc = MessageFormat.format(descFormat, args);
            }
            args = new String[]{mUsageType, desc};
            String mUsageOption = null;
            mUsageOption = option.isMandatory() ? MessageFormat.format(fmUsageOption, args) : MessageFormat.format(fmUsageOptionO, args);
            if (longUsage) {
                sbOpt.append(mUsageOption);
                continue;
            }
            sbOpt.append(' ');
            sbOpt.append(mUsageOption);
        }
        String usageFormat = res.getString("usage." + ver).replace("\n", lSep);
        Object[] args = new String[]{appLaunch, sbOpt.toString(), suffixArgs == null ? "" : suffixArgs, extraInfo == null ? "" : extraInfo.concat(lSep)};
        String result = MessageFormat.format(usageFormat, args);
        ps.print(result);
    }
}

