/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.Locale;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public final class BooleanOption
extends Option<Boolean> {
    private static final String[] VALS_TRUE = BUNDLE.getString("boolean.true").split(",");
    private static final String[] VALS_FALSE = BUNDLE.getString("boolean.false").split(",");

    public BooleanOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, false, minCount, maxCount);
    }

    public BooleanOption(String shortName, String longName, String description, boolean allowMany) {
        super(shortName, longName, description, false, false, allowMany);
    }

    @Override
    protected Boolean parseValue(String arg, Locale locale) throws OptionException {
        if (arg == null) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        String s = arg.toLowerCase().trim();
        for (String st : VALS_TRUE) {
            if (!s.equalsIgnoreCase(st)) continue;
            return Boolean.TRUE;
        }
        for (String sf : VALS_FALSE) {
            if (!s.equalsIgnoreCase(sf)) continue;
            return Boolean.FALSE;
        }
        throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }
}

