/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import snaq.util.jclap.CLAParser;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class LocalDateOption
extends Option<LocalDate> {
    static final DateTimeFormatter DF = DateTimeFormatter.ISO_LOCAL_DATE.withLocale(CLAParser.getLocale());

    public LocalDateOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany) {
        super(shortName, longName, description, true, mandatory, allowMany);
    }

    public LocalDateOption(String shortName, String longName, String description, int minCount, int maxCount) {
        super(shortName, longName, description, true, minCount, maxCount);
    }

    @Override
    public Class<LocalDate> getType() {
        return LocalDate.class;
    }

    @Override
    protected LocalDate parseValue(String arg) throws OptionException {
        if (arg == null) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        try {
            return LocalDate.parse(arg, DF);
        }
        catch (DateTimeParseException px) {
            px.printStackTrace();
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this);
        }
    }

    public DateTimeFormatter getDateFormat() {
        return DF;
    }

    public static void main(String[] args) throws OptionException {
        CLAParser parser = new CLAParser();
        String desc = String.format("Date (short format, e.g. \"%s\")", DF.format(Instant.now()));
        parser.addOption(new LocalDateOption("d", "date", desc, true, true));
        parser.addBooleanOption("?", "help", "Displays help information.", false);
        try {
            parser.parse(args);
            if (parser.getBooleanOptionValue("?").booleanValue()) {
                parser.printUsage(System.out, true);
                System.exit(0);
            }
            List<LocalDate> dates = parser.getOptionValues("d", LocalDate.class);
            for (LocalDate d : dates) {
                System.out.printf("Date specified: %s\n", DF.format(d));
            }
        }
        catch (OptionException ox) {
            try {
                if (parser.getBooleanOptionValue("?").booleanValue()) {
                    parser.printUsage(System.out, true);
                    System.exit(0);
                }
                System.err.println(ox.getMessage());
                parser.printUsage(System.out, false);
                System.exit(1);
            }
            catch (OptionException ox2) {
                ox2.printStackTrace();
            }
        }
    }
}

