/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap;

import java.util.Collection;
import snaq.util.jclap.EnumeratedOption;
import snaq.util.jclap.OptionException;

public final class EnumeratedIntegerOption
extends EnumeratedOption<Integer> {
    public EnumeratedIntegerOption(String shortName, String longName, String description, int minCount, int maxCount, Collection<Integer> allowedValues) {
        super(shortName, longName, description, minCount, maxCount, allowedValues);
    }

    public EnumeratedIntegerOption(String shortName, String longName, String description, boolean mandatory, boolean allowMany, Collection<Integer> allowedValues) {
        super(shortName, longName, description, mandatory, allowMany, allowedValues);
    }

    @Override
    protected Integer parseValue(String arg) throws OptionException {
        try {
            Integer val = Integer.valueOf(arg);
            for (Integer s : this.allowedValues) {
                if (!s.equals(val)) continue;
                return val;
            }
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
        catch (NumberFormatException nfx) {
            throw new OptionException(OptionException.Type.ILLEGAL_OPTION_VALUE, this, arg);
        }
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }
}

