/*
 * Decompiled with CFR 0.152.
 */
package snaq.util.jclap.example;

import java.io.File;
import java.util.List;
import snaq.util.jclap.CLAParser;
import snaq.util.jclap.Option;
import snaq.util.jclap.OptionException;

public class ParserExample {
    public static void main(String[] args) throws OptionException {
        CLAParser parser = new CLAParser();
        String EXTRA_ARGS = "<file> [<file>] ...";
        Option<Integer> oWidth = parser.addIntegerOption("w", "width", "Width of resized images.", true, false);
        parser.addIntegerOption("h", "height", "Height of resized images.", true, false);
        parser.addFolderExistingOption("d", "dir", "Output directory for resized images.", false, false);
        parser.addEnumStringOption("f", "format", "Output format of images.", false, false, new String[]{"jpg", "png"});
        parser.addBooleanOption("v", "verbose", "Displays extra runtime information.", true);
        parser.addBooleanOption("@", "version", "Displays the application version information.", false);
        parser.addBooleanOption("?", "help", "Displays help information.", false);
        try {
            parser.parse(args);
            if (parser.getBooleanOptionValue("@", false).booleanValue()) {
                System.out.printf("Version: %s\n", "x.x.x");
            }
            if (parser.getBooleanOptionValue("?").booleanValue() || args.length == 0) {
                parser.printUsage(System.out, true, "<file> [<file>] ...");
                System.exit(0);
            }
            Integer imageW = parser.getOptionValue(oWidth, null);
            Integer imageH = parser.getIntegerOptionValue("h", null);
            List<Boolean> lVerbose = parser.getBooleanOptionValues("verbose");
            int verbosity = lVerbose.size();
            if (verbosity > 0) {
                System.out.printf("Width:%d, Height:%d\n", imageW, imageH);
            }
            File dir = parser.getFileOptionValue("d", new File("."));
            String format = parser.getStringOptionValue("format", "jpg");
            if (verbosity > 0) {
                System.out.printf("Image format: %s\n", format);
            }
            if (verbosity > 0) {
                for (String s : parser.getNonOptionArguments()) {
                    System.out.printf("Unknown argument: %s\n", s);
                }
            }
            System.out.printf("width  : %d\n", imageW);
            System.out.printf("height : %d\n", imageH);
            System.out.printf("dir    : %s\n", dir);
            System.out.printf("format : %s\n", format);
            System.out.printf("verbose: %b (%d)\n", verbosity > 0, verbosity);
        }
        catch (OptionException ox) {
            try {
                if (parser.getBooleanOptionValue("?").booleanValue() || args.length == 0) {
                    parser.printUsage(System.out, true, "<file> [<file>] ...");
                    System.exit(0);
                }
                System.err.println(ox.getMessage());
                parser.printUsage(System.out, false, "<file> [<file>] ...");
                System.exit(1);
            }
            catch (OptionException ox2) {
                ox2.printStackTrace();
            }
        }
    }
}

